/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.java_websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClientKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSocketClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSocketClientImpl;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterSessionData;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpecBase;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0016J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClientImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClient;", "connectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;)V", "getConnectionParameters", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "restClient", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRestClient;", "urlString", "", "getUrlString", "()Ljava/lang/String;", "createSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterSessionData;", "kernelName", "notebookPath", "createWebSocketClientForKernel", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterWebSocketClient;", "kernelId", "onMessage", "Lkotlin/Function1;", "", "deleteSession", "sessionId", "dispose", "getKernelId", "getKernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "getKernelSpecs", "", "interrupt", "restart", "Companion", "intellij.python.jupyter"})
public final class JupyterClientImpl
implements JupyterClient {
    @NotNull
    private final String urlString;
    private final JupyterRestClient restClient;
    @NotNull
    private final JupyterConnectionParameters connectionParameters;
    private final HttpSession httpSession;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getUrlString() {
        return this.urlString;
    }

    @Override
    @Nullable
    public String getKernelId(@NotNull String kernelName) {
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        JsonElement jsonElement = this.restClient.postKernel(kernelName).get("id");
        return jsonElement != null ? jsonElement.getAsString() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<JupyterKernelSpec> getKernelSpecs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.restClient.getKernelSpecs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JupyterKernelSpec jupyterKernelSpec;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JsonObject p1 = (JsonObject)element$iv$iv;
            boolean bl2 = false;
            if (JupyterKernelSpecBase.Companion.fromServerJson(p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            JupyterKernelSpec it$iv$iv = jupyterKernelSpec;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public JupyterKernelSpec getKernelSpec(@NotNull String kernelName) {
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        JupyterKernelSpec jupyterKernelSpec = JupyterKernelSpecBase.Companion.fromServerJson(this.restClient.getKernelSpec(kernelName));
        if (jupyterKernelSpec == null) {
            throw (Throwable)new IllegalStateException();
        }
        return jupyterKernelSpec;
    }

    @Override
    @NotNull
    public JupyterSessionData createSession(@NotNull String kernelName, @NotNull String notebookPath) {
        Intrinsics.checkParameterIsNotNull((Object)kernelName, (String)"kernelName");
        Intrinsics.checkParameterIsNotNull((Object)notebookPath, (String)"notebookPath");
        JsonObject jsonObject = this.restClient.postSession(kernelName, notebookPath);
        boolean bl = false;
        boolean bl2 = false;
        JsonObject $this$run = jsonObject;
        boolean bl3 = false;
        JsonElement jsonElement = $this$run.get("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"get(\"id\")");
        String string = jsonElement.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"get(\"id\").asString");
        JsonElement jsonElement2 = $this$run.getAsJsonObject("kernel").get("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"getAsJsonObject(\"kernel\").get(\"id\")");
        String string2 = jsonElement2.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getAsJsonObject(\"kernel\").get(\"id\").asString");
        return new JupyterSessionData(string, string2);
    }

    @Override
    public void deleteSession(@NotNull String sessionId) {
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        this.restClient.deleteSession(sessionId);
    }

    @Override
    public void interrupt(@NotNull String kernelId) {
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        this.restClient.interruptKernel(kernelId);
    }

    @Override
    public void restart(@NotNull String kernelId) {
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        this.restClient.restartKernel(kernelId);
    }

    @Override
    @NotNull
    public JupyterWebSocketClient createWebSocketClientForKernel(@NotNull String kernelId, @NotNull Function1<? super String, Unit> onMessage) {
        Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
        Intrinsics.checkParameterIsNotNull(onMessage, (String)"onMessage");
        URI wsUri = Companion.getWebSocketUri$intellij_python_jupyter(new URL(this.getUrlString()), kernelId);
        return new JupyterWebSocketClientImpl(wsUri, this.httpSession, null, null, (Function2)new Function2<WebSocketClient, String, Unit>(onMessage){
            final /* synthetic */ Function1 $onMessage;

            public final void invoke(@NotNull WebSocketClient $noName_0, @NotNull String content) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
                this.$onMessage.invoke((Object)content);
            }
            {
                this.$onMessage = function1;
                super(2);
            }
        }, null, 44, null);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public JupyterConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public JupyterClientImpl(@NotNull JupyterConnectionParameters connectionParameters, @NotNull HttpSession httpSession) {
        Intrinsics.checkParameterIsNotNull((Object)connectionParameters, (String)"connectionParameters");
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        this.connectionParameters = connectionParameters;
        this.httpSession = httpSession;
        this.urlString = this.getConnectionParameters().getUrlString();
        this.restClient = new JupyterRestClient(this.httpSession);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterClientImpl$Companion;", "", "()V", "getWebSocketUri", "Ljava/net/URI;", "url", "Ljava/net/URL;", "kernelId", "", "getWebSocketUri$intellij_python_jupyter", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final URI getWebSocketUri$intellij_python_jupyter(@NotNull URL url, @NotNull String kernelId) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)kernelId, (String)"kernelId");
            String string = url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
            String kernelChannelPath = JupyterRestClientKt.resolveURIPath(string, "/api/kernels/" + kernelId + "/channels");
            return new URI("ws", url.getUserInfo(), url.getHost(), url.getPort(), kernelChannelPath, url.getQuery(), null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

