/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;

public class DockerUtil {
    private static final Pattern ID_PATTERN = Pattern.compile("[0-9a-f]+");
    private static final int ID_SHORT_LENGTH = 12;
    public static final String ID_PREFIX = "sha256:";

    public static String shortedId(String id) {
        if (id.length() > 12) {
            if (id.startsWith(ID_PREFIX) && ID_PATTERN.matcher(id.substring(ID_PREFIX.length())).matches()) {
                return id.substring(0, 12 + ID_PREFIX.length());
            }
            if (ID_PATTERN.matcher(id).matches()) {
                return id.substring(0, 12);
            }
        }
        return id;
    }

    public static boolean isStartedStatus(String status) {
        return status == null || status.startsWith("Up");
    }

    public static boolean isStoppedStatus(String status) {
        return status != null && (DockerUtil.isExitedStatus(status) || DockerUtil.isCreatedStatus(status));
    }

    public static boolean isExitedStatus(String status) {
        return status != null && status.startsWith("Exited");
    }

    public static boolean isCreatedStatus(String status) {
        return status != null && status.startsWith("Created");
    }

    public static <Src, Dest> Dest[] mapArray(Src[] input, Class<? extends Dest> destClass, Function<? super Src, ? extends Dest> mapper) {
        if (input == null) {
            return null;
        }
        return Arrays.stream(input).map(mapper).filter(Objects::nonNull).toArray(size -> DockerUtil.newArray(destClass, size));
    }

    private static <T> T[] newArray(Class<? extends T> destClass, int size) {
        return (Object[])Array.newInstance(destClass, size);
    }
}

