/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.stubs.elementTypes;

import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.psi.PuppetCompositePsiElement;
import com.intellij.lang.puppet.psi.stubs.PuppetStubBasedNamedPsiElement;
import com.intellij.lang.puppet.psi.stubs.PuppetStubNamedElement;
import com.intellij.lang.puppet.psi.stubs.elementTypes.PuppetStubElementType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetStubNamedElementTypeBase<S extends PuppetStubNamedElement, T extends PuppetCompositePsiElement>
extends PuppetStubElementType<S, T> {
    public PuppetStubNamedElementTypeBase(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    public void indexStub(@NotNull S stub, @NotNull IndexSink sink) {
        if (stub == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(2);
        }
        String fullQualifiedName = stub.getFullQualifiedName();
        assert (fullQualifiedName != null) : "shouldCreateStub method should filter this";
        sink.occurrence(this.getIndexKey(), (Object)fullQualifiedName);
    }

    protected abstract StubIndexKey<String, T> getIndexKey();

    public final void serialize(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(4);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getNamespaceName());
        this.serializeRest(stub, dataStream);
    }

    protected void serializeRest(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(5);
        }
        if (dataStream == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    public final S deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(7);
        }
        String name = dataStream.readNameString();
        assert (name != null) : "shouldCreateStub method should filter this";
        S s = this.deserializeRest(dataStream, parentStub, name, dataStream.readNameString());
        if (s == null) {
            PuppetStubNamedElementTypeBase.$$$reportNull$$$0(8);
        }
        return s;
    }

    protected abstract S deserializeRest(@NotNull StubInputStream var1, StubElement var2, @NotNull String var3, @Nullable String var4) throws IOException;

    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi = node.getPsi();
        return psi instanceof PuppetStubBasedNamedPsiElement && StringUtil.isNotEmpty((String)((PuppetStubBasedNamedPsiElement)psi).getFullQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/stubs/elementTypes/PuppetStubNamedElementTypeBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/stubs/elementTypes/PuppetStubNamedElementTypeBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeRest";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

