/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.references;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.PuppetRubyPluginsIndex;
import com.intellij.lang.puppet.psi.PuppetDataTypesManager;
import com.intellij.lang.puppet.psi.PuppetPsiFileImpl;
import com.intellij.lang.puppet.psi.PuppetTypeDefinition;
import com.intellij.lang.puppet.psi.references.PuppetPolyVariantCachingReferenceWithFullQualifiedName;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetTypeStubIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PuppetTypeDefinitionReference
extends PuppetPolyVariantCachingReferenceWithFullQualifiedName<PsiElement> {
    private final boolean myIncludeDataTypes;

    public PuppetTypeDefinitionReference(PsiElement psiElement, TextRange range, String fullQualifiedName) {
        this(psiElement, range, fullQualifiedName, false);
    }

    public PuppetTypeDefinitionReference(PsiElement psiElement, TextRange range, String fullQualifiedName, boolean includeDataTypes) {
        super(psiElement, range, fullQualifiedName);
        this.myIncludeDataTypes = includeDataTypes;
    }

    @Override
    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode) {
        PsiElement typeElement;
        PsiElement element;
        if (StringUtil.isEmpty((String)this.myFullQualifiedName)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                PuppetTypeDefinitionReference.$$$reportNull$$$0(0);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String lowerCasedName = StringUtil.toLowerCase((String)this.myFullQualifiedName);
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>(PuppetRubyPluginsIndex.findElementsByKey(PuppetRubyPluginsIndex.SymbolType.TYPE, lowerCasedName, (element = this.getElement()).getProject(), element.getResolveScope()));
        boolean gotRubyDefinedTypes = !elements.isEmpty();
        for (PuppetTypeDefinition typeDefinition : PuppetTypeStubIndex.getInstance().find(this.myFullQualifiedName, element)) {
            if (gotRubyDefinedTypes && PuppetPsiFileImpl.isInBuiltInStubsFile(typeDefinition)) continue;
            elements.add(typeDefinition);
        }
        if (this.myIncludeDataTypes && (typeElement = PuppetDataTypesManager.getDataTypeLightElementByName(this.myElement.getProject(), StringUtil.toLowerCase((String)this.myFullQualifiedName))) != null) {
            elements.add(typeElement);
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(elements);
        if (resolveResultArray == null) {
            PuppetTypeDefinitionReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = PuppetBundle.message("puppet.type.names.resource_definition", new Object[0]);
        if (string == null) {
            PuppetTypeDefinitionReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/puppet/psi/references/PuppetTypeDefinitionReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

