/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Comparing;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

public abstract class ComboBoxCellEditor
extends DefaultCellEditor {
    public ComboBoxCellEditor() {
        super(new JComboBox());
        this.setClickCountToStart(2);
    }

    protected abstract List<String> getComboBoxItems();

    protected boolean isComboboxEditable() {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.removeActionListener(this.delegate);
        boolean result = super.stopCellEditing();
        comboBox.addActionListener(this.delegate);
        return result;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String currentValue = (String)value;
        JComboBox component = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        component.removeActionListener(this.delegate);
        component.setBorder(null);
        component.removeAllItems();
        List<String> items = this.getComboBoxItems();
        int selected = -1;
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i);
            component.addItem(item);
            if (!Comparing.equal((String)item, (String)currentValue)) continue;
            selected = i;
        }
        if (selected == -1) {
            component.setEditable(true);
            component.setSelectedItem(currentValue);
            component.setEditable(false);
        } else {
            component.setSelectedIndex(selected);
        }
        component.setEditable(this.isComboboxEditable());
        component.addActionListener(this.delegate);
        return component;
    }
}

