/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.icons.ImageType;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class IconLoadMeasurer {
    private final ImageType type;
    private final AtomicInteger counter;
    private final AtomicInteger totalTime;
    private static final IconLoadMeasurer decodingSvg = new IconLoadMeasurer(ImageType.SVG);
    private static final IconLoadMeasurer decodingPng = new IconLoadMeasurer(ImageType.IMG);
    private static final IconLoadMeasurer loadingSvg = new IconLoadMeasurer(ImageType.SVG);
    private static final IconLoadMeasurer loadingPng = new IconLoadMeasurer(ImageType.IMG);

    public IconLoadMeasurer(@NotNull ImageType type) {
        if (type == null) {
            IconLoadMeasurer.$$$reportNull$$$0(0);
        }
        this.counter = new AtomicInteger();
        this.totalTime = new AtomicInteger();
        this.type = type;
    }

    @NotNull
    public static List<IconLoadMeasurer> getStats() {
        List<IconLoadMeasurer> list = Arrays.asList(loadingSvg, decodingSvg, loadingPng, decodingPng);
        if (list == null) {
            IconLoadMeasurer.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static void addDecoding(@NotNull ImageType type, int duration) {
        if (type == null) {
            IconLoadMeasurer.$$$reportNull$$$0(2);
        }
        (type == ImageType.SVG ? decodingSvg : decodingPng).addDuration(duration);
    }

    public static void addLoading(@NotNull ImageType type, int duration) {
        if (type == null) {
            IconLoadMeasurer.$$$reportNull$$$0(3);
        }
        (type == ImageType.SVG ? loadingSvg : loadingPng).addDuration(duration);
    }

    public int getCounter() {
        return this.counter.get();
    }

    public int getTotalTime() {
        return this.totalTime.get();
    }

    @NotNull
    public ImageType getType() {
        ImageType imageType = this.type;
        if (imageType == null) {
            IconLoadMeasurer.$$$reportNull$$$0(4);
        }
        return imageType;
    }

    private void addDuration(int duration) {
        this.counter.incrementAndGet();
        this.totalTime.updateAndGet(current -> current + duration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/icons/IconLoadMeasurer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/icons/IconLoadMeasurer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDecoding";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addLoading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

