/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ui.FileColorManager;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorConfigurationEditDialog;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public abstract class FileColorSettingsTable
extends JBTable {
    private static final int NAME_COLUMN = 0;
    private static final int COLOR_COLUMN = 1;
    private final List<? extends FileColorConfiguration> myOriginal;
    @NotNull
    private final FileColorManager myManager;

    public FileColorSettingsTable(@NotNull FileColorManager manager, @NotNull List<? extends FileColorConfiguration> configurations) {
        if (manager == null) {
            FileColorSettingsTable.$$$reportNull$$$0(0);
        }
        if (configurations == null) {
            FileColorSettingsTable.$$$reportNull$$$0(1);
        }
        super((TableModel)new ModelAdapter(manager, FileColorSettingsTable.copy(configurations)));
        this.myManager = manager;
        this.setStriped(true);
        this.myOriginal = configurations;
        this.setAutoResizeMode(3);
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setCellRenderer(new ScopeNameRenderer());
        TableColumn colorColumn = columnModel.getColumn(1);
        colorColumn.setCellRenderer(new ColorCellRenderer(manager));
    }

    private static List<FileColorConfiguration> copy(@NotNull List<? extends FileColorConfiguration> configurations) {
        if (configurations == null) {
            FileColorSettingsTable.$$$reportNull$$$0(2);
        }
        ArrayList<FileColorConfiguration> result2 = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration fileColorConfiguration : configurations) {
            try {
                result2.add(fileColorConfiguration.clone());
            }
            catch (CloneNotSupportedException e) {
                assert (false) : "Should not happen!";
            }
        }
        return result2;
    }

    protected abstract void apply(@NotNull List<? extends FileColorConfiguration> var1);

    public ModelAdapter getModel() {
        return (ModelAdapter)super.getModel();
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (e == null || e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 1) {
            return false;
        }
        Object at = this.getModel().getValueAt(row, column);
        if (!(at instanceof FileColorConfiguration)) {
            return false;
        }
        FileColorConfigurationEditDialog dialog2 = new FileColorConfigurationEditDialog(this.myManager, (FileColorConfiguration)at);
        dialog2.getScopeComboBox().setEnabled(false);
        dialog2.show();
        return false;
    }

    public boolean isModified() {
        List<FileColorConfiguration> current = this.getModel().getConfigurations();
        if (this.myOriginal.size() != current.size()) {
            return true;
        }
        for (int i = 0; i < current.size(); ++i) {
            if (this.myOriginal.get(i).equals(current.get(i))) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.getModel().setConfigurations(this.myOriginal);
    }

    public void performRemove() {
        int rowCount = this.getSelectedRowCount();
        if (rowCount > 0) {
            int[] rows = this.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                this.removeConfiguration(rows[i]);
            }
        }
    }

    public void moveUp() {
        int index;
        int rowCount = this.getSelectedRowCount();
        if (rowCount == 1 && (index = this.getModel().moveUp(this.getSelectedRows()[0])) > -1) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void moveDown() {
        int index;
        int rowCount = this.getSelectedRowCount();
        if (rowCount == 1 && (index = this.getModel().moveDown(this.getSelectedRows()[0])) > -1) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void apply() {
        if (this.isModified()) {
            this.apply(this.getModel().getConfigurations());
        }
    }

    public FileColorConfiguration removeConfiguration(int index) {
        FileColorConfiguration removed = this.getModel().remove(index);
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            if (index > rowCount - 1) {
                this.getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
            } else {
                this.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        return removed;
    }

    public void addConfiguration(@NotNull FileColorConfiguration configuration) {
        if (configuration == null) {
            FileColorSettingsTable.$$$reportNull$$$0(3);
        }
        this.getModel().add(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/FileColorSettingsTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ColorCellRenderer
    extends ScopeNameRenderer {
        private final FileColorManager myManager;

        private ColorCellRenderer(FileColorManager manager) {
            this.myManager = manager;
        }

        @Override
        Icon getIcon(FileColorConfiguration configuration) {
            Color color = this.myManager.getColor(configuration.getColorName());
            return color == null ? EmptyIcon.ICON_16 : JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 13, color, true));
        }

        @Override
        String getText(FileColorConfiguration configuration) {
            return configuration.getColorPresentableName();
        }
    }

    private static class ScopeNameRenderer
    extends DefaultTableCellRenderer {
        private ScopeNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        @Override
        protected void setValue(Object value) {
            Icon icon = null;
            String text2 = null;
            if (value instanceof FileColorConfiguration) {
                icon = this.getIcon((FileColorConfiguration)value);
                text2 = this.getText((FileColorConfiguration)value);
            }
            this.setIcon(icon);
            this.setText(text2 == null ? "" : FileColorManagerImpl.getAlias(text2));
        }

        Icon getIcon(FileColorConfiguration configuration) {
            return null;
        }

        String getText(FileColorConfiguration configuration) {
            return configuration.getScopeName();
        }
    }

    private static class ModelAdapter
    extends AbstractTableModel
    implements EditableModel {
        private final FileColorManager myManager;
        private List<FileColorConfiguration> myConfigurations;

        private ModelAdapter(FileColorManager manager, List<FileColorConfiguration> configurations) {
            this.myManager = manager;
            this.myConfigurations = configurations;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Scope" : "Color";
        }

        @Override
        public int getRowCount() {
            return this.myConfigurations.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return 0 <= rowIndex && rowIndex < this.myConfigurations.size() ? this.myConfigurations.get(rowIndex) : null;
        }

        @NotNull
        public List<FileColorConfiguration> getConfigurations() {
            List<FileColorConfiguration> list2 = this.myConfigurations;
            if (list2 == null) {
                ModelAdapter.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public FileColorConfiguration remove(int index) {
            FileColorConfiguration removed = this.myConfigurations.remove(index);
            this.fireTableRowsDeleted(index, index);
            return removed;
        }

        public void add(@NotNull FileColorConfiguration configuration) {
            if (configuration == null) {
                ModelAdapter.$$$reportNull$$$0(1);
            }
            this.myConfigurations.add(configuration);
            this.fireTableRowsInserted(this.myConfigurations.size() - 1, this.myConfigurations.size() - 1);
        }

        public void setConfigurations(List<? extends FileColorConfiguration> original) {
            this.myConfigurations = FileColorSettingsTable.copy(original);
            this.fireTableDataChanged();
        }

        public int moveUp(int index) {
            if (index > 0) {
                FileColorConfiguration configuration = this.myConfigurations.get(index);
                this.myConfigurations.remove(index);
                this.myConfigurations.add(index - 1, configuration);
                this.fireTableRowsUpdated(index - 1, index);
                return index - 1;
            }
            return -1;
        }

        public int moveDown(int index) {
            if (index < this.getRowCount() - 1) {
                FileColorConfiguration configuration = this.myConfigurations.get(index);
                this.myConfigurations.remove(index);
                this.myConfigurations.add(index + 1, configuration);
                this.fireTableRowsUpdated(index, index + 1);
                return index + 1;
            }
            return -1;
        }

        public void addRow() {
            FileColorConfigurationEditDialog dialog2 = new FileColorConfigurationEditDialog(this.myManager, null);
            dialog2.show();
            if (dialog2.getExitCode() == 0) {
                this.myConfigurations.add(dialog2.getConfiguration());
                int i = this.myConfigurations.size() - 1;
                this.fireTableRowsInserted(i, i);
            }
        }

        public void removeRow(int index) {
            this.myConfigurations.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            this.myConfigurations.add(newIndex, this.myConfigurations.remove(oldIndex));
            this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tabs/FileColorSettingsTable$ModelAdapter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tabs/FileColorSettingsTable$ModelAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

