/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.ClosableByLeftArrow;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.NextStepHandler;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPopupImpl
extends WizardPopup
implements ListPopup,
NextStepHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.list.ListPopupImpl");
    private MyList myList;
    private MyMouseMotionListener myMouseMotionListener;
    private MyMouseListener myMouseListener;
    private ListPopupModel myListModel;
    private int myIndexForShowingChild;
    private int myMaxRowCount;
    private boolean myAutoHandleBeforeShow;

    @Deprecated
    public ListPopupImpl(@NotNull ListPopupStep aStep, int maxRowCount) {
        if (aStep == null) {
            ListPopupImpl.$$$reportNull$$$0(0);
        }
        this(aStep);
        this.setMaxRowCount(maxRowCount);
    }

    @Deprecated
    public ListPopupImpl(@NotNull ListPopupStep aStep) {
        if (aStep == null) {
            ListPopupImpl.$$$reportNull$$$0(1);
        }
        this((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()), null, aStep, null);
    }

    public ListPopupImpl(@Nullable Project project, @NotNull ListPopupStep aStep) {
        if (aStep == null) {
            ListPopupImpl.$$$reportNull$$$0(2);
        }
        this(project, null, aStep, null);
    }

    public ListPopupImpl(@Nullable Project project, @Nullable WizardPopup aParent, @NotNull ListPopupStep aStep, Object parentValue) {
        if (aStep == null) {
            ListPopupImpl.$$$reportNull$$$0(3);
        }
        super(project, aParent, (PopupStep<Object>)aStep);
        this.myIndexForShowingChild = -1;
        this.myMaxRowCount = 30;
        this.setParentValue(parentValue);
        this.replacePasteAction();
    }

    public void setMaxRowCount(int maxRowCount) {
        if (maxRowCount <= 0) {
            return;
        }
        this.myMaxRowCount = maxRowCount;
    }

    public void showUnderneathOfLabel(@NotNull JLabel label2) {
        if (label2 == null) {
            ListPopupImpl.$$$reportNull$$$0(4);
        }
        int offset = -UIUtil.getListCellHPadding() - UIUtil.getListViewportPadding().left;
        if (label2.getIcon() != null) {
            offset += label2.getIcon().getIconWidth() + label2.getIconTextGap();
        }
        this.show(new RelativePoint((Component)label2, new Point(offset, label2.getHeight() + 1)));
    }

    protected ListPopupModel getListModel() {
        return this.myListModel;
    }

    @Override
    protected boolean beforeShow() {
        this.myList.addMouseMotionListener(this.myMouseMotionListener);
        this.myList.addMouseListener(this.myMouseListener);
        this.myList.setVisibleRowCount(Math.min(this.myMaxRowCount, this.myListModel.getSize()));
        boolean shouldShow = super.beforeShow();
        if (this.myAutoHandleBeforeShow) {
            boolean toDispose = this.tryToAutoSelect(true);
            shouldShow &= !toDispose;
        }
        return shouldShow;
    }

    @Override
    public void goBack() {
        this.myList.clearSelection();
        super.goBack();
    }

    @Override
    protected void afterShow() {
        this.tryToAutoSelect(false);
    }

    private boolean tryToAutoSelect(boolean handleFinalChoices) {
        ListPopupStep<Object> listStep = this.getListStep();
        boolean selected2 = false;
        if (listStep instanceof MultiSelectionListPopupStep) {
            int[] indices = ((MultiSelectionListPopupStep)listStep).getDefaultOptionIndices();
            if (indices.length > 0) {
                ScrollingUtil.ensureIndexIsVisible((JList)((Object)this.myList), (int)indices[0], (int)0);
                this.myList.setSelectedIndices(indices);
                selected2 = true;
            }
        } else {
            int defaultIndex = listStep.getDefaultOptionIndex();
            if (defaultIndex >= 0 && defaultIndex < this.myList.getModel().getSize()) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)defaultIndex);
                selected2 = true;
            }
        }
        if (!selected2) {
            this.selectFirstSelectableItem();
        }
        if (listStep.isAutoSelectionEnabled()) {
            if (!this.isVisible() && this.getSelectableCount() == 1) {
                return this._handleSelect(handleFinalChoices, null);
            }
            if (this.isVisible() && this.hasSingleSelectableItemWithSubmenu()) {
                return this._handleSelect(handleFinalChoices, null);
            }
        }
        return false;
    }

    protected boolean shouldUseStatistics() {
        return true;
    }

    private boolean autoSelectUsingStatistics() {
        String filter = this.getSpeedSearch().getFilter();
        if (!StringUtil.isEmpty((String)filter)) {
            int maxUseCount = -1;
            int mostUsedValue = -1;
            int elementsCount = this.myListModel.getSize();
            for (int i = 0; i < elementsCount; ++i) {
                Object value = this.myListModel.getElementAt(i);
                String text2 = this.getListStep().getTextFor(value);
                int count = StatisticsManager.getInstance().getUseCount(new StatisticsInfo("#list_popup:" + this.myStep.getTitle() + "#" + filter, text2));
                if (count <= maxUseCount) continue;
                maxUseCount = count;
                mostUsedValue = i;
            }
            if (mostUsedValue > 0) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)mostUsedValue);
                return true;
            }
        }
        return false;
    }

    private void selectFirstSelectableItem() {
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            if (!this.getListStep().isSelectable(this.myListModel.getElementAt(i))) continue;
            this.myList.setSelectedIndex(i);
            break;
        }
    }

    private boolean hasSingleSelectableItemWithSubmenu() {
        boolean oneSubmenuFound = false;
        int countSelectables = 0;
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            Object elementAt = this.myListModel.getElementAt(i);
            if (!this.getListStep().isSelectable(elementAt)) continue;
            ++countSelectables;
            if (!this.getStep().hasSubstep(elementAt)) continue;
            if (oneSubmenuFound) {
                return false;
            }
            oneSubmenuFound = true;
        }
        return oneSubmenuFound && countSelectables == 1;
    }

    private int getSelectableCount() {
        int count = 0;
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            Object each = this.myListModel.getElementAt(i);
            if (!this.getListStep().isSelectable(each)) continue;
            ++count;
        }
        return count;
    }

    public JList getList() {
        return this.myList;
    }

    @Override
    protected JComponent createContent() {
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.myMouseListener = new MyMouseListener();
        ListPopupStep<Object> step = this.getListStep();
        this.myListModel = new ListPopupModel<Object>(this, this.getSpeedSearch(), step);
        this.myList = new MyList();
        if (this.myStep.getTitle() != null) {
            this.myList.getAccessibleContext().setAccessibleName(this.myStep.getTitle());
        }
        if (step instanceof ListPopupStepEx) {
            ((ListPopupStepEx)step).setEmptyText(this.myList.getEmptyText());
        }
        this.myList.setSelectionMode(this.isMultiSelectionEnabled() ? 2 : 0);
        this.myList.setSelectedIndex(0);
        Insets padding = UIUtil.getListViewportPadding();
        this.myList.setBorder(new EmptyBorder(padding));
        ScrollingUtil.installActions((JList)((Object)this.myList));
        this.myList.setCellRenderer(this.getListElementRenderer());
        this.registerAction("handleSelection1", 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupImpl.this.handleSelect(true);
            }
        });
        this.myList.getActionMap().put("selectNextColumn", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupImpl.this.handleSelect(false);
            }
        });
        this.myList.getActionMap().put("selectPreviousColumn", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListPopupImpl.this.isClosableByLeftArrow()) {
                    ListPopupImpl.this.goBack();
                }
            }
        });
        this.myList.setCursor(Cursor.getPredefinedCursor(12));
        return this.myList;
    }

    private boolean isMultiSelectionEnabled() {
        return this.getListStep() instanceof MultiSelectionListPopupStep;
    }

    private boolean isClosableByLeftArrow() {
        return this.getParent() != null || this.myStep instanceof ClosableByLeftArrow;
    }

    @Override
    protected ActionMap getActionMap() {
        return this.myList.getActionMap();
    }

    @Override
    protected InputMap getInputMap() {
        return this.myList.getInputMap();
    }

    protected ListCellRenderer getListElementRenderer() {
        return new PopupListElementRenderer(this);
    }

    public ListPopupStep<Object> getListStep() {
        return (ListPopupStep)this.myStep;
    }

    @Override
    public void dispose() {
        this.myList.removeMouseMotionListener(this.myMouseMotionListener);
        this.myList.removeMouseListener(this.myMouseListener);
        super.dispose();
    }

    protected int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    protected Rectangle getCellBounds(int i) {
        return this.myList.getCellBounds(i, i);
    }

    @Override
    public void disposeChildren() {
        this.setIndexForShowingChild(-1);
        super.disposeChildren();
    }

    @Override
    protected void onAutoSelectionTimer() {
        if (this.myList.getModel().getSize() > 0 && !this.myList.isSelectionEmpty()) {
            this.handleSelect(false);
        } else {
            this.disposeChildren();
            this.setIndexForShowingChild(-1);
        }
    }

    public void handleSelect(boolean handleFinalChoices) {
        this._handleSelect(handleFinalChoices, null);
    }

    public void handleSelect(boolean handleFinalChoices, InputEvent e) {
        this._handleSelect(handleFinalChoices, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _handleSelect(boolean handleFinalChoices, @Nullable InputEvent e) {
        PopupStep nextStep;
        if (this.myList.getSelectedIndex() == -1) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter() && this.myList.getModel().getSize() == 0) {
            return false;
        }
        if (this.myList.getSelectedIndex() == this.getIndexForShowingChild()) {
            if (this.myChild != null && !this.myChild.isVisible()) {
                this.setIndexForShowingChild(-1);
            }
            return false;
        }
        Object[] selectedValues = this.myList.getSelectedValues();
        ListPopupStep<Object> listStep = this.getListStep();
        if (!listStep.isSelectable(selectedValues[0])) {
            return false;
        }
        if ((listStep instanceof MultiSelectionListPopupStep && !((MultiSelectionListPopupStep)listStep).hasSubstep(Arrays.asList(selectedValues)) || !listStep.hasSubstep(selectedValues[0])) && !handleFinalChoices) {
            return false;
        }
        this.disposeChildren();
        if (this.myListModel.getSize() == 0) {
            this.setFinalRunnable(this.myStep.getFinalRunnable());
            this.setOk(true);
            this.disposeAllParents(e);
            this.setIndexForShowingChild(-1);
            return true;
        }
        this.valuesSelected(selectedValues);
        AtomicBoolean insideOnChosen = new AtomicBoolean(true);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (insideOnChosen.get()) {
                LOG.error("Showing dialogs from popup onChosen can result in focus issues. Please put the handler into BaseStep.doFinalStep or PopupStep.getFinalRunnable.");
            }
        }, ModalityState.any());
        try {
            nextStep = listStep instanceof MultiSelectionListPopupStep ? ((MultiSelectionListPopupStep)listStep).onChosen(Arrays.asList(selectedValues), handleFinalChoices) : (e != null && listStep instanceof ListPopupStepEx ? ((ListPopupStepEx)listStep).onChosen(selectedValues[0], handleFinalChoices, e.getModifiers()) : listStep.onChosen(selectedValues[0], handleFinalChoices));
        }
        finally {
            insideOnChosen.set(false);
        }
        return this.handleNextStep(nextStep, selectedValues.length == 1 ? selectedValues[0] : null, e);
    }

    private void valuesSelected(Object[] values) {
        String filter;
        if (this.shouldUseStatistics() && !StringUtil.isEmpty((String)(filter = this.getSpeedSearch().getFilter()))) {
            for (Object value : values) {
                String text2 = this.getListStep().getTextFor(value);
                StatisticsManager.getInstance().incUseCount(new StatisticsInfo("#list_popup:" + this.getListStep().getTitle() + "#" + filter, text2));
            }
        }
    }

    @Override
    public void handleNextStep(PopupStep nextStep, Object parentValue) {
        this.handleNextStep(nextStep, parentValue, null);
    }

    public boolean handleNextStep(PopupStep nextStep, Object parentValue, InputEvent e) {
        if (nextStep != PopupStep.FINAL_CHOICE) {
            Point point = this.myList.indexToLocation(this.myList.getSelectedIndex());
            SwingUtilities.convertPointToScreen(point, (Component)((Object)this.myList));
            this.myChild = this.createPopup(this, nextStep, parentValue);
            if (this.myChild instanceof ListPopupImpl) {
                for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                    ((ListPopupImpl)this.myChild).addListSelectionListener(listener2);
                }
            }
            JComponent container = this.getContent();
            int y = point.y;
            if (parentValue != null && this.getListModel().isSeparatorAboveOf(parentValue)) {
                SeparatorWithText swt = new SeparatorWithText();
                swt.setCaption(this.getListModel().getCaptionAboveOf(parentValue));
                y += swt.getPreferredSize().height - 1;
            }
            this.myChild.show(container, container.getLocationOnScreen().x + container.getWidth() - 2, y, true);
            this.setIndexForShowingChild(this.myList.getSelectedIndex());
            return false;
        }
        this.setOk(true);
        this.setFinalRunnable(this.myStep.getFinalRunnable());
        this.disposeAllParents(e);
        this.setIndexForShowingChild(-1);
        return true;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myList.addListSelectionListener(listSelectionListener);
    }

    protected boolean isActionClick(MouseEvent e) {
        return UIUtil.isActionClick((MouseEvent)e, (int)502, (boolean)true);
    }

    public Object[] getSelectedValues() {
        return this.myList.getSelectedValues();
    }

    protected boolean handleFinalChoices(MouseEvent e, Object selectedValue, ListPopupStep<Object> listStep) {
        return selectedValue == null || !listStep.hasSubstep(selectedValue) || !listStep.isSelectable(selectedValue) || !this.isOnNextStepButton(e);
    }

    private boolean isOnNextStepButton(MouseEvent e) {
        int index = this.myList.getSelectedIndex();
        Rectangle bounds2 = this.myList.getCellBounds(index, index);
        if (bounds2 != null) {
            JBInsets.removeFrom((Rectangle)bounds2, (Insets)UIUtil.getListCellPadding());
        }
        Point point = e.getPoint();
        return bounds2 != null && point.getX() > (double)bounds2.width + bounds2.getX() - (double)AllIcons.Icons.Ide.NextStep.getIconWidth();
    }

    @Override
    protected void process(KeyEvent aEvent) {
        this.myList.processKeyEvent(aEvent);
    }

    private int getIndexForShowingChild() {
        return this.myIndexForShowingChild;
    }

    private void setIndexForShowingChild(int aIndexForShowingChild) {
        this.myIndexForShowingChild = aIndexForShowingChild;
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.myListModel.refilter();
        if (!(this.myListModel.getSize() <= 0 || this.shouldUseStatistics() && this.autoSelectUsingStatistics())) {
            this.selectBestMatch();
        }
    }

    private void selectBestMatch() {
        int fullMatchIndex = this.myListModel.getClosestMatchIndex();
        if (fullMatchIndex != -1) {
            this.myList.setSelectedIndex(fullMatchIndex);
        }
        if (this.myListModel.getSize() <= this.myList.getSelectedIndex() || !this.myListModel.isVisible(this.myList.getSelectedValue())) {
            this.myList.setSelectedIndex(0);
        }
    }

    @Override
    protected void onSelectByMnemonic(Object value) {
        if (this.myListModel.isVisible(value)) {
            this.myList.setSelectedValue(value, true);
            this.myList.repaint();
            this.handleSelect(true);
        }
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.myList;
    }

    @Override
    protected void onChildSelectedFor(Object value) {
        if (this.myList.getSelectedValue() != value) {
            this.myList.setSelectedValue(value, false);
        }
    }

    public void setHandleAutoSelectionBeforeShow(boolean autoHandle) {
        this.myAutoHandleBeforeShow = autoHandle;
    }

    @Override
    public boolean isModalContext() {
        return true;
    }

    @Override
    public void showInBestPositionFor(@NotNull Editor editor) {
        if (editor == null) {
            ListPopupImpl.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.handleSelect(true);
            if (!Disposer.isDisposed((Disposable)this)) {
                Disposer.dispose((Disposable)this);
            }
        } else {
            super.showInBestPositionFor(editor);
        }
    }

    private void replacePasteAction() {
        if (this.myStep.isSpeedSearchEnabled()) {
            this.getList().getActionMap().put(TransferHandler.getPasteAction().getValue("Name"), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListPopupImpl.this.getSpeedSearch().type((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor));
                    ListPopupImpl.this.getSpeedSearch().update();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/popup/list/ListPopupImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showUnderneathOfLabel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showInBestPositionFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyList
    extends JBList
    implements DataProvider {
        MyList() {
            super((ListModel)ListPopupImpl.this.myListModel);
            HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)((Object)this));
        }

        public void processKeyEvent(KeyEvent e) {
            e.setSource((Object)this);
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (!ListPopupImpl.this.isMultiSelectionEnabled() && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                e.consume();
            }
            if (UIUtil.isActionClick((MouseEvent)e, (int)501) && ListPopupImpl.this.isOnNextStepButton(e)) {
                e.consume();
            }
            super.processMouseEvent(e);
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyList.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return ListPopupImpl.this.myList.getSelectedValue();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ListPopupImpl.this.myList.getSelectedValues();
            }
            if (PlatformDataKeys.SPEED_SEARCH_COMPONENT.is(dataId) && ListPopupImpl.this.mySpeedSearchPatternField != null && ListPopupImpl.this.mySpeedSearchPatternField.isVisible()) {
                return ListPopupImpl.this.mySpeedSearchPatternField;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ui/popup/list/ListPopupImpl$MyList", "getData"));
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!ListPopupImpl.this.isActionClick(e) || ListPopupImpl.this.isMultiSelectionEnabled() && UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                return;
            }
            IdeEventQueue.getInstance().blockNextEvents(e);
            Object selectedValue = ListPopupImpl.this.myList.getSelectedValue();
            ListPopupStep<Object> listStep = ListPopupImpl.this.getListStep();
            ListPopupImpl.this.handleSelect(ListPopupImpl.this.handleFinalChoices(e, selectedValue, listStep), e);
            ListPopupImpl.this.stopTimer();
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private int myLastSelectedIndex = -2;
        private Point myLastMouseLocation;

        private MyMouseMotionListener() {
        }

        private boolean isMouseMoved(Point location) {
            if (this.myLastMouseLocation == null) {
                this.myLastMouseLocation = location;
                return false;
            }
            return !this.myLastMouseLocation.equals(location);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isMouseMoved(e.getLocationOnScreen())) {
                return;
            }
            Point point = e.getPoint();
            int index = ListPopupImpl.this.myList.locationToIndex(point);
            if (index != this.myLastSelectedIndex) {
                if (!ListPopupImpl.this.isMultiSelectionEnabled() || !UIUtil.isSelectionButtonDown((MouseEvent)e) && ListPopupImpl.this.myList.getSelectedIndices().length <= 1) {
                    ListPopupImpl.this.myList.setSelectedIndex(index);
                }
                ListPopupImpl.this.restartTimer();
                this.myLastSelectedIndex = index;
            }
            ListPopupImpl.this.notifyParentOnChildSelection();
        }
    }
}

