/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.ProjectTaskState;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.task.impl.ProjectTaskManagerListener;
import com.intellij.task.impl.ProjectTaskScope;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.task.ProjectTaskManager");
    private final ProjectTaskRunner myDummyTaskRunner;
    private final ProjectTaskListener myEventPublisher;
    private final List<ProjectTaskManagerListener> myListeners;

    public ProjectTaskManagerImpl(@NotNull Project project) {
        if (project == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myDummyTaskRunner = new DummyTaskRunner();
        this.myListeners = new CopyOnWriteArrayList<ProjectTaskManagerListener>();
        this.myEventPublisher = (ProjectTaskListener)project.getMessageBus().syncPublisher(ProjectTaskListener.TOPIC);
    }

    public void build(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback2) {
        if (modules == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(1);
        }
        this.run(this.createModulesBuildTask(modules, true, true, false), callback2);
    }

    public void rebuild(@NotNull Module[] modules, @Nullable ProjectTaskNotification callback2) {
        if (modules == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(2);
        }
        this.run(this.createModulesBuildTask(modules, false, false, false), callback2);
    }

    public void compile(@NotNull VirtualFile[] files2, @Nullable ProjectTaskNotification callback2) {
        if (files2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(3);
        }
        List buildTasks = ContainerUtil.map(Arrays.stream(files2).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(file2, false))).entrySet(), entry -> new ModuleFilesBuildTaskImpl((Module)entry.getKey(), false, (Collection)entry.getValue()));
        this.run(new ProjectTaskList(buildTasks), callback2);
    }

    public void build(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(4);
        }
        this.doBuild(buildableElements, callback2, true);
    }

    public void rebuild(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(5);
        }
        this.doBuild(buildableElements, callback2, false);
    }

    public void buildAllModules(@Nullable ProjectTaskNotification callback2) {
        this.run(this.createAllModulesBuildTask(true, this.myProject), callback2);
    }

    public void rebuildAllModules(@Nullable ProjectTaskNotification callback2) {
        this.run(this.createAllModulesBuildTask(false, this.myProject), callback2);
    }

    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project).getModules(), isIncrementalBuild, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module}), isIncrementalBuild, includeDependentModules, includeRuntimeDependencies);
    }

    public ProjectTask createModulesBuildTask(Module[] modules, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return modules.length == 1 ? new ModuleBuildTaskImpl(modules[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies) : new ProjectTaskList(ContainerUtil.map(Arrays.asList(modules), module -> new ModuleBuildTaskImpl((Module)module, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies)));
    }

    public ProjectTask createBuildTask(boolean isIncrementalBuild, ProjectModelBuildableElement ... buildableElements) {
        return buildableElements.length == 1 ? new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>(buildableElements[0], isIncrementalBuild) : new ProjectTaskList(ContainerUtil.map(Arrays.asList(buildableElements), buildableElement -> new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>((ProjectModelBuildableElement)buildableElement, isIncrementalBuild)));
    }

    public void run(@NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback2) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(6);
        }
        this.run(new ProjectTaskContext(), projectTask, callback2);
    }

    public void run(@NotNull ProjectTaskContext context, @NotNull ProjectTask projectTask, @Nullable ProjectTaskNotification callback2) {
        if (context == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(7);
        }
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(8);
        }
        SmartList toRun = new SmartList();
        Consumer taskClassifier = arg_0 -> this.lambda$run$6((List)toRun, arg_0);
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), (Consumer<? super Collection<? extends ProjectTask>>)taskClassifier);
        context.putUserData(ProjectTaskScope.KEY, (Object)new ProjectTaskScope((List)toRun){
            final /* synthetic */ List val$toRun;
            {
                this.val$toRun = list2;
            }

            @Override
            @NotNull
            public <T extends ProjectTask> List<T> getRequestedTasks(@NotNull Class<T> instanceOf) {
                if (instanceOf == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList tasks = new ArrayList();
                this.val$toRun.forEach(pair -> ((Collection)pair.second).stream().filter(instanceOf::isInstance).map(task2 -> task2).forEach(tasks::add));
                ArrayList arrayList = tasks;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instanceOf";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRequestedTasks";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRequestedTasks";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myEventPublisher.started(context);
        Runnable runnable2 = () -> this.lambda$run$9(context, callback2, (List)toRun);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        } else {
            runnable2.run();
        }
    }

    @NotNull
    private static Supplier<List<String>> moduleOutputPathsProvider(@NotNull Module module) {
        if (module == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(9);
        }
        Supplier<List<String>> supplier = () -> (List)ReadAction.compute(() -> JBIterable.of((Object[])OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().getClassesRoots()).filterMap(file2 -> file2.isDirectory() && !file2.getFileSystem().isReadOnly() ? file2.getPath() : null).toList());
        if (supplier == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(10);
        }
        return supplier;
    }

    public final void addListener(@NotNull ProjectTaskManagerListener listener2) {
        if (listener2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(11);
        }
        this.myListeners.add(listener2);
    }

    private static void sendSuccessNotify(@Nullable ProjectTaskNotification notification) {
        if (notification != null) {
            notification.finished(new ProjectTaskResult(false, 0, 0));
        }
    }

    private static void sendAbortedNotify(@Nullable ProjectTaskNotification notification) {
        if (notification != null) {
            notification.finished(new ProjectTaskResult(true, 0, 0));
        }
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<? super Collection<? extends ProjectTask>> consumer) {
        if (tasks == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(13);
        }
        for (ProjectTask projectTask : tasks) {
            Collection<ProjectTask> taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask));
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer);
        }
        consumer.consume(tasks);
    }

    @NotNull
    private static ProjectTaskRunner[] getTaskRunners() {
        ProjectTaskRunner[] projectTaskRunnerArray = (ProjectTaskRunner[])ProjectTaskRunner.EP_NAME.getExtensions();
        if (projectTaskRunnerArray == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(14);
        }
        return projectTaskRunnerArray;
    }

    private void doBuild(@NotNull ProjectModelBuildableElement[] buildableElements, @Nullable ProjectTaskNotification callback2, boolean isIncrementalBuild) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(15);
        }
        this.run(this.createBuildTask(isIncrementalBuild, buildableElements), callback2);
    }

    private /* synthetic */ void lambda$run$9(ProjectTaskContext context, ProjectTaskNotification callback2, List toRun) {
        for (ProjectTaskManagerListener listener2 : this.myListeners) {
            try {
                listener2.beforeRun(context);
            }
            catch (ExecutionException e) {
                ProjectTaskManagerImpl.sendAbortedNotify(new ListenerNotificator(context, callback2));
                return;
            }
        }
        if (toRun.isEmpty()) {
            ProjectTaskManagerImpl.sendSuccessNotify(new ListenerNotificator(context, callback2));
            return;
        }
        ProjectTaskResultsAggregator callbacksCollector = new ProjectTaskResultsAggregator(new ListenerNotificator(context, callback2), toRun.size());
        for (Pair pair : toRun) {
            ProjectTaskRunnerNotification notification = new ProjectTaskRunnerNotification((Collection)pair.second, callbacksCollector);
            if (((Collection)pair.second).isEmpty()) {
                ProjectTaskManagerImpl.sendSuccessNotify(notification);
                continue;
            }
            ProjectTaskRunner runner = (ProjectTaskRunner)pair.first;
            if (!runner.isFileGeneratedEventsSupported()) {
                ((Collection)pair.second).stream().filter(ModuleBuildTask.class::isInstance).map(task2 -> ((ModuleBuildTask)task2).getModule()).forEach(module -> context.addDirtyOutputPathsProvider(ProjectTaskManagerImpl.moduleOutputPathsProvider(module)));
            }
            runner.run(this.myProject, context, (ProjectTaskNotification)notification, (Collection)pair.second);
        }
    }

    private /* synthetic */ void lambda$run$6(List toRun, Collection tasks) {
        Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> Arrays.stream(ProjectTaskManagerImpl.getTaskRunners()).filter(runner -> {
            try {
                return runner.canRun(this.myProject, aTask);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Broken project task runner: " + runner.getClass().getName(), (Throwable)e);
                return false;
            }
        }).findFirst().orElse(this.myDummyTaskRunner)));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry : toBuild.entrySet()) {
            toRun.add(Pair.create((Object)entry.getKey(), entry.getValue()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildableElements";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleOutputPathsProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moduleOutputPathsProvider";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitTasks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectTaskResultsAggregator {
        private final ProjectTaskNotification myDelegate;
        private final AtomicInteger myProgressCounter;
        private final AtomicInteger myErrorsCounter;
        private final AtomicInteger myWarningsCounter;
        private final AtomicBoolean myAbortedFlag;
        private final Map<ProjectTask, ProjectTaskState> myTasksState;

        private ProjectTaskResultsAggregator(@NotNull ProjectTaskNotification delegate, int expectedResults) {
            if (delegate == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(0);
            }
            this.myTasksState = ContainerUtil.newConcurrentMap();
            this.myDelegate = delegate;
            this.myProgressCounter = new AtomicInteger(expectedResults);
            this.myErrorsCounter = new AtomicInteger();
            this.myWarningsCounter = new AtomicInteger();
            this.myAbortedFlag = new AtomicBoolean(false);
        }

        public void add(@NotNull ProjectTaskResult executionResult) {
            if (executionResult == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(1);
            }
            int inProgress = this.myProgressCounter.decrementAndGet();
            int allErrors = this.myErrorsCounter.addAndGet(executionResult.getErrors());
            int allWarnings = this.myWarningsCounter.addAndGet(executionResult.getWarnings());
            this.myTasksState.putAll(executionResult.getTasksState());
            if (executionResult.isAborted()) {
                this.myAbortedFlag.set(true);
            }
            if (inProgress <= 0) {
                ProjectTaskResult result2 = new ProjectTaskResult(this.myAbortedFlag.get(), allErrors, allWarnings, this.myTasksState);
                this.myDelegate.finished(result2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionResult";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ProjectTaskResultsAggregator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProjectTaskRunnerNotification
    implements ProjectTaskNotification {
        private final ProjectTaskResultsAggregator myAggregator;
        private final Collection<? extends ProjectTask> myTasks;

        private ProjectTaskRunnerNotification(@NotNull Collection<? extends ProjectTask> tasks, @NotNull ProjectTaskResultsAggregator aggregator) {
            if (tasks == null) {
                ProjectTaskRunnerNotification.$$$reportNull$$$0(0);
            }
            if (aggregator == null) {
                ProjectTaskRunnerNotification.$$$reportNull$$$0(1);
            }
            this.myTasks = tasks;
            this.myAggregator = aggregator;
        }

        public void finished(@NotNull ProjectTaskResult result2) {
            if (result2 == null) {
                ProjectTaskRunnerNotification.$$$reportNull$$$0(2);
            }
            if (result2.getTasksState().isEmpty()) {
                final boolean aborted = result2.isAborted();
                final int errors = result2.getErrors();
                ProjectTaskState state = new ProjectTaskState(){

                    public boolean isSkipped() {
                        return aborted;
                    }

                    public boolean isFailed() {
                        return errors > 0;
                    }
                };
                Map tasksState = StreamEx.of(this.myTasks).toMap(Function.identity(), task2 -> state);
                result2 = new ProjectTaskResult(aborted, errors, result2.getWarnings(), tasksState);
            }
            this.myAggregator.add(result2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aggregator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ProjectTaskRunnerNotification";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ListenerNotificator
    implements ProjectTaskNotification {
        @Nullable
        private final ProjectTaskNotification myDelegate;
        @NotNull
        private final ProjectTaskContext myContext;

        private ListenerNotificator(@Nullable ProjectTaskContext context, ProjectTaskNotification delegate) {
            if (context == null) {
                ListenerNotificator.$$$reportNull$$$0(0);
            }
            this.myContext = context;
            this.myDelegate = delegate;
        }

        public void finished(@NotNull ProjectTaskResult executionResult) {
            if (executionResult == null) {
                ListenerNotificator.$$$reportNull$$$0(1);
            }
            if (!executionResult.isAborted() && executionResult.getErrors() == 0) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        for (ProjectTaskManagerListener listener2 : ProjectTaskManagerImpl.this.myListeners) {
                            listener2.afterRun(this.myContext, executionResult);
                        }
                        this.notify(this.myContext, executionResult);
                    }
                    catch (ExecutionException e) {
                        LOG.debug((Throwable)e);
                        this.notify(this.myContext, new ProjectTaskResult(false, executionResult.getErrors() + 1, executionResult.getWarnings(), executionResult.getTasksState()));
                    }
                });
            } else {
                this.notify(this.myContext, executionResult);
            }
        }

        private void notify(@NotNull ProjectTaskContext context, @NotNull ProjectTaskResult executionResult) {
            if (context == null) {
                ListenerNotificator.$$$reportNull$$$0(2);
            }
            if (executionResult == null) {
                ListenerNotificator.$$$reportNull$$$0(3);
            }
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (!ProjectTaskManagerImpl.this.myProject.isDisposed()) {
                    ProjectTaskManagerImpl.this.myEventPublisher.finished(context, executionResult);
                }
                if (this.myDelegate != null) {
                    this.myDelegate.finished(executionResult);
                }
            }, (ModalityState)ModalityState.defaultModalityState());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionResult";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ListenerNotificator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finished";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notify";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DummyTaskRunner
    extends ProjectTaskRunner {
        private DummyTaskRunner() {
        }

        public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback2, @NotNull Collection<? extends ProjectTask> tasks) {
            if (project == null) {
                DummyTaskRunner.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DummyTaskRunner.$$$reportNull$$$0(1);
            }
            if (tasks == null) {
                DummyTaskRunner.$$$reportNull$$$0(2);
            }
            ProjectTaskManagerImpl.sendSuccessNotify(callback2);
        }

        public boolean canRun(@NotNull ProjectTask projectTask) {
            if (projectTask == null) {
                DummyTaskRunner.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectTask";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$DummyTaskRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

