/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.UpDownHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;

public class ComboBoxVisibilityPanel<V>
extends VisibilityPanelBase<V> {
    private final JLabel myLabel;
    protected final JComboBox myComboBox;
    private final Map<V, String> myNamesMap = new HashMap<V, String>();

    public ComboBoxVisibilityPanel(String name, V[] options, String[] presentableNames) {
        this.setLayout(new BorderLayout(0, 2));
        this.myLabel = new JLabel(name);
        this.add((Component)this.myLabel, "North");
        this.myComboBox = new JComboBox<V>(options);
        this.myComboBox.setRenderer(this.getRenderer());
        IJSwingUtilities.adjustComponentsOnMac(this.myLabel, this.myComboBox);
        this.add((Component)this.myComboBox, "South");
        for (int i = 0; i < options.length; ++i) {
            this.myNamesMap.put((String)options[i], presentableNames[i]);
        }
        this.myComboBox.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxVisibilityPanel.this.stateChanged(new ChangeEvent(ComboBoxVisibilityPanel.this));
            }
        });
        this.myLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ComboBoxVisibilityPanel.this.myComboBox.showPopup();
            }
        });
        DialogUtil.registerMnemonic((JLabel)this.myLabel, (JComponent)this.myComboBox);
    }

    protected ListCellRenderer<?> getRenderer() {
        return SimpleListCellRenderer.create((String)"", this.myNamesMap::get);
    }

    public ComboBoxVisibilityPanel(String name, V[] options) {
        this(name, options, ComboBoxVisibilityPanel.getObjectNames(options));
    }

    private static String[] getObjectNames(Object[] options) {
        String[] names2 = new String[options.length];
        for (int i = 0; i < options.length; ++i) {
            names2[i] = options[i].toString();
        }
        return names2;
    }

    public ComboBoxVisibilityPanel(V[] options) {
        this(RefactoringBundle.message((String)"visibility.combo.title"), options);
    }

    public ComboBoxVisibilityPanel(V[] options, String[] presentableNames) {
        this(RefactoringBundle.message((String)"visibility.combo.title"), options, presentableNames);
    }

    protected void addOption(int index, V option, String presentableName, boolean select) {
        this.myNamesMap.put((String)option, presentableName);
        this.myComboBox.insertItemAt(option, index);
        if (select) {
            this.myComboBox.setSelectedIndex(index);
        }
    }

    protected void addOption(V option) {
        this.addOption(this.myComboBox.getItemCount(), option, option.toString(), false);
    }

    public void setDisplayedMnemonicIndex(int index) {
        this.myLabel.setDisplayedMnemonicIndex(index);
    }

    @Override
    public V getVisibility() {
        return (V)this.myComboBox.getSelectedItem();
    }

    public final void registerUpDownActionsFor(JComponent input) {
        UpDownHandler.register(input, this.myComboBox);
    }

    @Override
    public void setVisibility(V visibility) {
        this.myComboBox.setSelectedItem(visibility);
        this.stateChanged(new ChangeEvent(this));
    }
}

