/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForwardDependenciesBuilder
extends DependenciesBuilder {
    private final Map<PsiFile, Set<PsiFile>> myDirectDependencies;
    private int myTransitive;
    @Nullable
    private GlobalSearchScope myTargetScope;

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(1);
        }
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myTransitive = 0;
    }

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable GlobalSearchScope targetScope) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(3);
        }
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myTransitive = 0;
        this.myTargetScope = targetScope;
    }

    public ForwardDependenciesBuilder(Project project, AnalysisScope scope, int transitive) {
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myTransitive = 0;
        this.myTransitive = transitive;
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisScopeBundle.message((String)"forward.dependencies.usage.view.root.node.text", (Object[])new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisScopeBundle.message((String)"forward.dependencies.usage.view.initial.text", (Object[])new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return false;
    }

    @Override
    public void analyze() {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        psiManager.startBatchFilesProcessingMode();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        try {
            this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(PsiFile file2) {
                    ForwardDependenciesBuilder.this.visit(file2, fileIndex, psiManager, 0);
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private void visit(PsiFile file2, final ProjectFileIndex fileIndex, PsiManager psiManager, int depth) {
        final FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (indicator != null) {
            if (indicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator.setText(AnalysisScopeBundle.message((String)"package.dependencies.progress.text", (Object[])new Object[0]));
            if (virtualFile != null) {
                indicator.setText2(this.getRelativeToProjectPath(virtualFile));
            }
            if (this.myTotalFileCount > 0) {
                indicator.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
            }
        }
        boolean isInLibrary = virtualFile == null || fileIndex.isInLibrary(virtualFile);
        HashSet<Object> collectedDeps = new HashSet<Object>();
        HashSet<PsiFile> processed2 = new HashSet<PsiFile>();
        collectedDeps.add(file2);
        do {
            if (depth++ > this.getTransitiveBorder()) {
                return;
            }
            for (PsiFile psiFile : new HashSet(collectedDeps)) {
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile != null) {
                    if (indicator != null) {
                        indicator.setText2(this.getRelativeToProjectPath(vFile));
                    }
                    if (!isInLibrary && fileIndex.isInLibrary(vFile)) {
                        processed2.add(psiFile);
                    }
                }
                final HashSet found = new HashSet();
                if (processed2.contains(psiFile)) continue;
                processed2.add(psiFile);
                ForwardDependenciesBuilder.analyzeFileDependencies(psiFile, new DependenciesBuilder.DependencyProcessor(){

                    @Override
                    public void process(PsiElement place, PsiElement dependency) {
                        PsiFile dependencyFile = dependency.getContainingFile();
                        if (dependencyFile != null) {
                            VirtualFile virtualFile;
                            if (viewProvider == dependencyFile.getViewProvider()) {
                                return;
                            }
                            if (dependencyFile.isPhysical() && (virtualFile = dependencyFile.getVirtualFile()) != null && (fileIndex.isInContent(virtualFile) || fileIndex.isInLibrary(virtualFile)) && (ForwardDependenciesBuilder.this.myTargetScope == null || ForwardDependenciesBuilder.this.myTargetScope.contains(virtualFile))) {
                                PsiElement navigationElement = dependencyFile.getNavigationElement();
                                found.add(navigationElement instanceof PsiFile ? (PsiFile)navigationElement : dependencyFile);
                            }
                        }
                    }
                });
                Set<PsiFile> deps = this.getDependencies().get(file2);
                if (deps == null) {
                    deps = new HashSet<PsiFile>();
                    this.getDependencies().put(file2, deps);
                }
                deps.addAll(found);
                this.getDirectDependencies().put(psiFile, new HashSet(found));
                collectedDeps.addAll(found);
                psiManager.dropResolveCaches();
                InjectedLanguageManager.getInstance((Project)file2.getProject()).dropFileCaches(file2);
            }
            collectedDeps.removeAll(processed2);
        } while (this.isTransitive() && !collectedDeps.isEmpty());
    }

    @Override
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        return this.myDirectDependencies;
    }

    @Override
    public boolean isTransitive() {
        return this.myTransitive > 0;
    }

    @Override
    public int getTransitiveBorder() {
        return this.myTransitive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
        }
        objectArray[1] = "com/intellij/packageDependencies/ForwardDependenciesBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

