/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.LargeFileEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LargeFileNotificationProvider
extends EditorNotifications.Provider {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"large.file.editor.notification");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"large.file.editor.notification.hidden");
    private static final String DISABLE_KEY = "large.file.editor.notification.disabled";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(3);
        }
        if (!(fileEditor instanceof LargeFileEditorProvider.LargeTextFileEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        if (editor.getUserData(HIDDEN_KEY) != null || PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.createActionLabel("Hide notification", () -> {
            editor.putUserData(HIDDEN_KEY, (Object)"true");
            LargeFileNotificationProvider.update(file2, project);
        });
        panel2.createActionLabel("Don't show again", () -> {
            PropertiesComponent.getInstance().setValue(DISABLE_KEY, "true");
            LargeFileNotificationProvider.update(file2, project);
        });
        return panel2.text(String.format("The file is too large: %s. Showing a read-only preview of the first %s.", StringUtil.formatFileSize((long)file2.getLength()), StringUtil.formatFileSize((long)FileUtilRt.LARGE_FILE_PREVIEW_SIZE)));
    }

    private static void update(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            LargeFileNotificationProvider.$$$reportNull$$$0(5);
        }
        EditorNotifications.getInstance((Project)project).updateNotifications(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/LargeFileNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

