/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class RootFileElement
extends FileElement {
    private VirtualFile[] myFiles;
    private Object[] myChildren;

    public RootFileElement(@NotNull VirtualFile[] files2, String name, boolean showFileSystemRoots) {
        if (files2 == null) {
            RootFileElement.$$$reportNull$$$0(0);
        }
        super(files2.length == 1 ? files2[0] : null, name);
        this.myFiles = files2.length == 0 && showFileSystemRoots ? null : files2;
    }

    public Object[] getChildren() {
        if (this.myChildren == null) {
            if (this.myFiles == null) {
                this.myFiles = RootFileElement.getFileSystemRoots();
            }
            ArrayList<FileElement> children2 = new ArrayList<FileElement>();
            for (VirtualFile file2 : this.myFiles) {
                if (file2 == null) continue;
                children2.add(new FileElement(file2, file2.getPresentableUrl()));
            }
            this.myChildren = ArrayUtil.toObjectArray(children2);
        }
        return this.myChildren;
    }

    private static VirtualFile[] getFileSystemRoots() {
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        File[] ioRoots = File.listRoots();
        if (ioRoots != null) {
            for (File root : ioRoots) {
                String path = FileUtil.toSystemIndependentName((String)root.getAbsolutePath());
                VirtualFile file2 = localFileSystem2.findFileByPath(path);
                if (file2 == null) continue;
                roots.add(file2);
            }
        }
        return VfsUtilCore.toVirtualFileArray(roots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileChooser/ex/RootFileElement", "<init>"));
    }
}

