/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.file.exclude.ProjectPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnforcedPlainTextFileTypeManager
implements ProjectManagerListener {
    private Collection[] explicitlyMarkedSets = new Collection[0];
    private Project[] explicitlyMarkedProjects = new Project[0];

    public EnforcedPlainTextFileTypeManager() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)this);
    }

    public boolean isMarkedAsPlainText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        for (Collection explicitlyMarked : this.explicitlyMarkedSets) {
            if (!explicitlyMarked.contains(file2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isApplicableFor(@Nullable VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        if (ScratchUtil.isScratch(file2)) {
            return false;
        }
        FileType originalType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence());
        return !originalType.isBinary() && originalType != FileTypes.PLAIN_TEXT && originalType != StdFileTypes.JAVA;
    }

    public void markAsPlainText(@NotNull Project project, VirtualFile ... files2) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(2);
        }
        this.setPlainTextStatus(project, true, files2);
    }

    public void resetOriginalFileType(@NotNull Project project, VirtualFile ... files2) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(4);
        }
        this.setPlainTextStatus(project, false, files2);
    }

    private void setPlainTextStatus(@NotNull Project project, boolean toAdd, VirtualFile ... files2) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            for (VirtualFile file2 : files2) {
                boolean changed;
                if (!fileIndex.isInContent(file2) && !fileIndex.isInLibrarySource(file2) && !fileIndex.isExcluded(file2)) continue;
                boolean bl = changed = toAdd ? ProjectPlainTextFileTypeManager.getInstance(project).addFile(file2) : ProjectPlainTextFileTypeManager.getInstance(project).removeFile(file2);
                if (!changed) continue;
                this.ensureProjectFileUpToDate(project);
                FileBasedIndex.getInstance().requestReindex(file2);
            }
            FileContentUtilCore.reparseFiles((VirtualFile[])files2);
        });
    }

    private void ensureProjectFileUpToDate(@NotNull Project project) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(7);
        }
        int i = ArrayUtil.indexOf((Object[])this.explicitlyMarkedProjects, (Object)project);
        ProjectPlainTextFileTypeManager projectPlainTextFileTypeManager = ProjectPlainTextFileTypeManager.getInstance(project);
        if (i == -1) {
            this.explicitlyMarkedProjects = (Project[])ArrayUtil.append((Object[])this.explicitlyMarkedProjects, (Object)project);
            this.explicitlyMarkedSets = (Collection[])ArrayUtil.append((Object[])this.explicitlyMarkedSets, (Object)projectPlainTextFileTypeManager.getFiles());
        } else {
            this.explicitlyMarkedSets[i] = projectPlainTextFileTypeManager.getFiles();
        }
    }

    private void ensureProjectFileSetRemoved(@NotNull Project project) {
        int i;
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(8);
        }
        if ((i = ArrayUtil.indexOf((Object[])this.explicitlyMarkedProjects, (Object)project)) >= 0) {
            this.explicitlyMarkedProjects = (Project[])ArrayUtil.remove((Object[])this.explicitlyMarkedProjects, (int)i);
            this.explicitlyMarkedSets = (Collection[])ArrayUtil.remove((Object[])this.explicitlyMarkedSets, (int)i);
        }
    }

    public static EnforcedPlainTextFileTypeManager getInstance() {
        return (EnforcedPlainTextFileTypeManager)ServiceManager.getService(EnforcedPlainTextFileTypeManager.class);
    }

    public void projectOpened(@NotNull Project project) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(9);
        }
        this.addProjectPlainTextFiles(project);
    }

    public void projectClosed(@NotNull Project project) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(10);
        }
        this.ensureProjectFileSetRemoved(project);
    }

    private void addProjectPlainTextFiles(@NotNull Project project) {
        if (project == null) {
            EnforcedPlainTextFileTypeManager.$$$reportNull$$$0(11);
        }
        if (!project.isDisposed()) {
            this.ensureProjectFileUpToDate(project);
            Disposer.register((Disposable)project, () -> this.ensureProjectFileSetRemoved(project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/file/exclude/EnforcedPlainTextFileTypeManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarkedAsPlainText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsPlainText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resetOriginalFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setPlainTextStatus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureProjectFileUpToDate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureProjectFileSetRemoved";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "projectOpened";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "projectClosed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addProjectPlainTextFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

