/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.CliResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationStarterBase
implements ApplicationStarter {
    private final String myCommandName;
    private final int[] myArgsCount;

    protected ApplicationStarterBase(@NotNull String commandName, int ... possibleArgumentsCount) {
        if (commandName == null) {
            ApplicationStarterBase.$$$reportNull$$$0(0);
        }
        this.myCommandName = commandName;
        this.myArgsCount = possibleArgumentsCount;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public boolean isHeadless() {
        return false;
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<? extends CliResult> processExternalCommandLineAsync(@NotNull String[] args, @Nullable String currentDirectory) {
        Future<? extends CliResult> future2;
        if (args == null) {
            ApplicationStarterBase.$$$reportNull$$$0(1);
        }
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog((String)this.getUsageMessage(), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getInformationIcon());
            Future future3 = CliResult.error((int)1, (String)this.getUsageMessage());
            if (future3 == null) {
                ApplicationStarterBase.$$$reportNull$$$0(2);
            }
            return future3;
        }
        try {
            Future<? extends CliResult> future4 = this.processCommand(args, currentDirectory);
            future2 = future4;
        }
        catch (Exception e) {
            String message = String.format("Error executing %s: %s", this.getCommandName(), e.getMessage());
            Messages.showMessageDialog((String)message, (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getErrorIcon());
            Future future5 = CliResult.error((int)1, (String)message);
            Future future6 = future5;
            if (future6 == null) {
                ApplicationStarterBase.$$$reportNull$$$0(4);
            }
            return future6;
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        if (future2 == null) {
            ApplicationStarterBase.$$$reportNull$$$0(3);
        }
        return future2;
    }

    protected static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    private boolean checkArguments(String[] args) {
        return Arrays.binarySearch(this.myArgsCount, args.length - 1) != -1 && this.getCommandName().equals(args[0]);
    }

    public abstract String getUsageMessage();

    @NotNull
    protected abstract Future<? extends CliResult> processCommand(@NotNull String[] var1, @Nullable String var2) throws Exception;

    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main(String[] args) {
        int exitCode = 0;
        try {
            Future<? extends CliResult> commandFuture = this.processCommand(args, null);
            CliResult result2 = commandFuture.get();
            if (result2.getMessage() != null) {
                System.out.println(result2.getMessage());
            }
            exitCode = result2.getReturnCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        System.exit(exitCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ApplicationStarterBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ApplicationStarterBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalCommandLineAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processExternalCommandLineAsync";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

