/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightWorkspaceSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.tooltips.TooltipActionProvider;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class EditorSettingsStatisticsCollector
extends ApplicationUsagesCollector {
    EditorSettingsStatisticsCollector() {
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("editor.settings.ide" == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        return "editor.settings.ide";
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> set = new HashSet<MetricEvent>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsExternalizable esDefault = new EditorSettingsExternalizable();
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isVirtualSpace(), "caretAfterLineEnd");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isCaretInsideTabs(), "caretInsideTabs");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isAdditionalPageAtBottom(), "virtualSpaceAtFileBottom");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), "softWraps");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), "softWraps.console");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isUseSoftWraps(SoftWrapAppliancePlaces.PREVIEW), "softWraps.preview");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isUseCustomSoftWrapIndent(), "softWraps.relativeIndent");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isAllSoftWrapsShown(), "softWraps.showAll");
        MetricEventUtilKt.addIfDiffers(set, es, esDefault, s -> s.getStripTrailingSpaces(), "stripTrailingSpaces");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isEnsureNewLineAtEOF(), "ensureNewlineAtEOF");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isShowQuickDocOnMouseOverElement(), "quickDocOnMouseHover");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isBlinkCaret(), "blinkingCaret");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isBlockCursor(), "blockCaret");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isRightMarginShown(), "rightMargin");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isLineNumbersShown(), "lineNumbers");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.areGutterIconsShown(), "gutterIcons");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isFoldingOutlineShown(), "foldingOutline");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isWhitespacesShown() && s.isLeadingWhitespacesShown(), "showLeadingWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isWhitespacesShown() && s.isInnerWhitespacesShown(), "showInnerWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isWhitespacesShown() && s.isTrailingWhitespacesShown(), "showTrailingWhitespace");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isIndentGuidesShown(), "indentGuides");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isSmoothScrolling(), "animatedScroll");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isDndEnabled(), "dragNDrop");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isWheelFontChangeEnabled(), "wheelZoom");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isMouseClickSelectionHonorsCamelWords(), "mouseCamel");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isVariableInplaceRenameEnabled(), "inplaceRename");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isPreselectRename(), "preselectOnRename");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isShowInlineLocalDialog(), "inlineDialog");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isRefrainFromScrolling(), "minimizeScrolling");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION, "afterReformatNotification");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.getOptions().SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION, "afterOptimizeNotification");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isSmartHome(), "smartHome");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isCamelWords(), "camelWords");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isShowParameterNameHints(), "editor.inlay.parameter.hints");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isBreadcrumbsAbove(), "breadcrumbsAbove");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isBreadcrumbsShown(), "all.breadcrumbs");
        MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isShowIntentionBulb(), "intentionBulb");
        for (String language : es.getOptions().getLanguageBreadcrumbsMap().keySet()) {
            FeatureUsageData data = new FeatureUsageData().addLanguage(language);
            MetricEventUtilKt.addBoolIfDiffers(set, es, esDefault, s -> s.isBreadcrumbsShownFor(language), "breadcrumbs", data);
        }
        RichCopySettings rcs = RichCopySettings.getInstance();
        RichCopySettings rcsDefault = new RichCopySettings();
        MetricEventUtilKt.addBoolIfDiffers(set, rcs, rcsDefault, s -> s.isEnabled(), "richCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        CodeInsightSettings cisDefault = new CodeInsightSettings();
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.AUTO_POPUP_PARAMETER_INFO, "parameterAutoPopup");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.AUTO_POPUP_JAVADOC_INFO, "javadocAutoPopup");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.AUTO_POPUP_COMPLETION_LOOKUP, "completionAutoPopup");
        MetricEventUtilKt.addIfDiffers(set, cis, cisDefault, s -> s.COMPLETION_CASE_SENSITIVE, "completionCaseSensitivity");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.isSelectAutopopupSuggestionsByChars(), "autoPopupCharComplete");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_CODE_COMPLETION, "autoCompleteBasic");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, "autoCompleteSmart");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, "parameterInfoFullSignature");
        MetricEventUtilKt.addIfDiffers(set, cis, cisDefault, s -> s.getBackspaceMode(), "smartBackspace");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.SMART_INDENT_ON_ENTER, "indentOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.INSERT_BRACE_ON_ENTER, "braceOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.JAVADOC_STUB_ON_ENTER, "javadocOnEnter");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.SMART_END_ACTION, "smartEnd");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.JAVADOC_GENERATE_CLOSING_TAG, "autoCloseJavadocTags");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.SURROUND_SELECTION_ON_QUOTE_TYPED, "surroundByQuoteOrBrace");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.AUTOINSERT_PAIR_BRACKET, "pairBracketAutoInsert");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.AUTOINSERT_PAIR_QUOTE, "pairQuoteAutoInsert");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.REFORMAT_BLOCK_ON_RBRACE, "reformatOnRBrace");
        MetricEventUtilKt.addIfDiffers(set, cis, cisDefault, s -> s.REFORMAT_ON_PASTE, "reformatOnPaste");
        MetricEventUtilKt.addIfDiffers(set, cis, cisDefault, s -> s.ADD_IMPORTS_ON_PASTE, "importsOnPaste");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.HIGHLIGHT_BRACES, "bracesHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.HIGHLIGHT_SCOPE, "scopeHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.HIGHLIGHT_IDENTIFIER_UNDER_CARET, "identifierUnderCaretHighlight");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, "autoAddImports");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION, "completionHints");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.SHOW_EXTERNAL_ANNOTATIONS_INLINE, "externalAnnotationsInline");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.SHOW_INFERRED_ANNOTATIONS_INLINE, "inferredAnnotationsInline");
        MetricEventUtilKt.addBoolIfDiffers(set, cis, cisDefault, s -> s.TAB_EXITS_BRACKETS_AND_QUOTES, "tabExitsBracketsAndQuotes");
        EditorSettingsStatisticsCollector.addTooltipActionsMetricIfDiffers(set);
        DaemonCodeAnalyzerSettings dcas = DaemonCodeAnalyzerSettings.getInstance();
        DaemonCodeAnalyzerSettings dcasDefault = new DaemonCodeAnalyzerSettings();
        MetricEventUtilKt.addBoolIfDiffers(set, dcas, dcasDefault, s -> s.isNextErrorActionGoesToErrorsFirst(), "nextErrorActionGoesToErrorsFirst");
        MetricEventUtilKt.addIfDiffers(set, dcas, dcasDefault, s -> s.getAutoReparseDelay(), "autoReparseDelay");
        MetricEventUtilKt.addBoolIfDiffers(set, dcas, dcasDefault, s -> s.isShowSmallIconsInGutter(), "showSmallIconsInGutter");
        MetricEventUtilKt.addIfDiffers(set, dcas, dcasDefault, s -> s.getErrorStripeMarkMinHeight(), "errorStripeMarkMinHeight");
        MetricEventUtilKt.addBoolIfDiffers(set, dcas, dcasDefault, s -> s.isSuppressWarnings(), "suppressWarnings");
        MetricEventUtilKt.addBoolIfDiffers(set, dcas, dcasDefault, s -> s.isImportHintEnabled(), "importHintEnabled");
        MetricEventUtilKt.addBoolIfDiffers(set, dcas, dcasDefault, s -> s.SHOW_METHOD_SEPARATORS, "showMethodSeparators");
        HashSet<MetricEvent> hashSet = set;
        if (hashSet == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static void addTooltipActionsMetricIfDiffers(@NotNull Set<MetricEvent> set) {
        boolean value;
        if (set == null) {
            EditorSettingsStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (!(value = TooltipActionProvider.isShowActions())) {
            set.add(MetricEventFactoryKt.newBooleanMetric("show.actions.in.tooltip", value));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTooltipActionsMetricIfDiffers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProjectUsages
    extends ProjectUsagesCollector {
        @Override
        @NotNull
        public String getGroupId() {
            if ("editor.settings.project" == null) {
                ProjectUsages.$$$reportNull$$$0(0);
            }
            return "editor.settings.project";
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectUsages.$$$reportNull$$$0(1);
            }
            HashSet<MetricEvent> set = new HashSet<MetricEvent>();
            CodeInsightWorkspaceSettings ciws = CodeInsightWorkspaceSettings.getInstance(project);
            CodeInsightWorkspaceSettings ciwsDefault = new CodeInsightWorkspaceSettings();
            MetricEventUtilKt.addBoolIfDiffers(set, ciws, ciwsDefault, s -> s.optimizeImportsOnTheFly, "autoOptimizeImports");
            HashSet<MetricEvent> hashSet = set;
            if (hashSet == null) {
                ProjectUsages.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector$ProjectUsages";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

