/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.internal.statistic.actions.AddGroupToLocalWhitelistDialog;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogTestWhitelistPersistence;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AddTestGroupToLocalWhitelistAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        final AddGroupToLocalWhitelistDialog dialog2 = new AddGroupToLocalWhitelistDialog(project);
        boolean result2 = dialog2.showAndGet();
        if (!result2 || StringUtil.isEmpty((String)dialog2.getGroupId()) || StringUtil.isEmpty((String)dialog2.getRecorderId())) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Adding Test Group and Updating Whitelist...", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                String recorderId = dialog2.getRecorderId();
                SensitiveDataValidator validator = SensitiveDataValidator.getInstance(recorderId);
                validator.update();
                try {
                    if (dialog2.isCustomRules()) {
                        EventLogTestWhitelistPersistence.addGroupWithCustomRules(recorderId, dialog2.getGroupId(), dialog2.getCustomRules());
                    } else {
                        EventLogTestWhitelistPersistence.addTestGroup(recorderId, dialog2.getGroupId());
                    }
                    validator.reload();
                    AddTestGroupToLocalWhitelistAction.this.showNotification(project, NotificationType.INFORMATION, "Group '" + dialog2.getGroupId() + "' was added to local whitelist");
                }
                catch (IOException ex) {
                    AddTestGroupToLocalWhitelistAction.this.showNotification(project, NotificationType.ERROR, "Failed updating local list: " + ex.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/statistic/actions/AddTestGroupToLocalWhitelistAction$1", "run"));
            }
        });
    }

    protected void showNotification(@NotNull Project project, @NotNull NotificationType type, @NotNull String message) {
        if (project == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(1);
        }
        if (type == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(2);
        }
        if (message == null) {
            AddTestGroupToLocalWhitelistAction.$$$reportNull$$$0(3);
        }
        Notifications.Bus.notify((Notification)new Notification("FeatureUsageStatistics", "Feature Usage Statistics", message, type), (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/actions/AddTestGroupToLocalWhitelistAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

