/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeChooserUtils {
    private static final String CURRENT_FILE_SCOPE_NAME = IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]);
    private static final String OPEN_FILES_SCOPE_NAME = IdeBundle.message((String)"scope.open.files", (Object[])new Object[0]);

    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project, @Nullable String scopeName) {
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(0);
        }
        if (scopeName == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        if (OPEN_FILES_SCOPE_NAME.equals(scopeName)) {
            GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopes.openFilesScope((Project)project));
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        if (CURRENT_FILE_SCOPE_NAME.equals(scopeName)) {
            Object[] array = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            List files2 = ContainerUtil.createMaybeSingletonList((Object)ArrayUtil.getFirstElement((Object[])array));
            GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, (Collection)files2, (String)CURRENT_FILE_SCOPE_NAME);
            GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, scope);
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        for (SearchScope scope : PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, null, false, false, false, false, true)) {
            if (!(scope instanceof GlobalSearchScope) || !scope.getDisplayName().equals(scopeName)) continue;
            if (scope instanceof ScratchesSearchScope) {
                ScratchesSearchScope scratchesSearchScope = (ScratchesSearchScope)scope;
                if (scratchesSearchScope == null) {
                    ScopeChooserUtils.$$$reportNull$$$0(4);
                }
                return scratchesSearchScope;
            }
            GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, (GlobalSearchScope)scope);
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }
        for (SearchScope scope : ChangeListsScopesProvider.getInstance(project).getFilteredScopes()) {
            if (!scope.getName().equals(scopeName)) continue;
            GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope));
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        for (Iterator<Object> iterator : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = iterator.getEditableScopes()) {
                if (!scope.getName().equals(scopeName)) continue;
                GlobalSearchScope globalSearchScope = ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope));
                if (globalSearchScope == null) {
                    ScopeChooserUtils.$$$reportNull$$$0(7);
                }
                return globalSearchScope;
            }
        }
        if (scopeName.startsWith("Module '") && scopeName.endsWith("'")) {
            GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(11);
        }
        GlobalSearchScope globalSearchScope = scope.intersectWith(ProjectScope.getContentScope((Project)project));
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWithContentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithContentScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

