/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextBorder;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class WinIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public static final String HOVER_PROPERTY = "JTextField.hover";
    private MouseListener hoverListener;

    public static ComponentUI createUI(JComponent c2) {
        return new WinIntelliJTextFieldUI();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.hoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.getComponent(), HOVER_PROPERTY);
        this.getComponent().addMouseListener(this.hoverListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.hoverListener != null) {
            this.getComponent().removeMouseListener(this.hoverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c2 = this.getComponent();
        if (ComponentUtil.getParentOfType(JComboBox.class, (Component)c2) != null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Container parent = c2.getParent();
            if (c2.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
            }
            if (c2.getBorder() instanceof WinIntelliJTextBorder) {
                WinIntelliJTextFieldUI.paintTextFieldBackground(c2, g2);
            } else if (c2.isOpaque()) {
                super.paintBackground(g);
            }
        }
        finally {
            g2.dispose();
        }
    }

    static void paintTextFieldBackground(JComponent c2, Graphics2D g2) {
        g2.setColor(c2.isEnabled() ? c2.getBackground() : UIManager.getColor("Button.background"));
        if (!c2.isEnabled()) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.35f));
        }
        Rectangle r = new Rectangle(c2.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)2));
        WinIntelliJTextFieldUI.adjustInWrapperRect(r, c2);
        g2.fill(r);
    }

    static void adjustInWrapperRect(Rectangle r, Component c2) {
        int delta;
        if (ComponentUtil.getParentOfType(Wrapper.class, (Component)c2) != null && WinIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c2) && (delta = c2.getHeight() - c2.getPreferredSize().height) > 0) {
            JBInsets.removeFrom((Rectangle)r, (Insets)JBInsets.create((int)((delta -= delta % 2 == 0 ? 0 : 1) / 2), (int)0));
        }
    }

    @Override
    protected int getMinimumHeight(int textHeight) {
        JTextComponent c2 = this.getComponent();
        Insets i = c2.getInsets();
        return DarculaEditorTextFieldBorder.isComboBoxEditor(c2) || ComponentUtil.getParentOfType(JSpinner.class, (Component)c2) != null ? textHeight : WinIntelliJTextBorder.MINIMUM_HEIGHT.get() + i.top + i.bottom;
    }

    @Override
    protected int getSearchIconGap() {
        return 0;
    }

    @Override
    protected Insets getDefaultMargins() {
        JTextComponent c2 = this.getComponent();
        return DarculaUIUtil.isCompact(c2) || DarculaUIUtil.isTableCellEditor(c2) ? JBInsets.create((int)0, (int)3) : JBInsets.create((int)2, (int)6);
    }

    @Override
    protected int getClearIconGap() {
        return JBUIScale.scale((int)3);
    }
}

