/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.ide.ui.laf.darcula.ui.DarculaJBPopupComboPopup;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacIntelliJComboBoxUI
extends DarculaComboBoxUI {
    private static final Icon ICON = EmptyIcon.create((Icon)LafIconLookup.getIcon((String)"comboRight", (boolean)false, (boolean)false, (boolean)true, (boolean)false));
    private static final Icon EDITABLE_ICON = EmptyIcon.create((Icon)LafIconLookup.getIcon((String)"comboRight", (boolean)false, (boolean)false, (boolean)true, (boolean)true));

    public static ComponentUI createUI(JComponent c2) {
        return new MacIntelliJComboBoxUI();
    }

    @Override
    protected void installDarculaDefaults() {
        this.comboBox.setOpaque(false);
    }

    @Override
    protected void uninstallDarculaDefaults() {
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.comboBox.getBackground();
        Color fg = this.comboBox.getForeground();
        BasicArrowButton button2 = new BasicArrowButton(5, bg, fg, fg, fg){

            @Override
            public void paint(Graphics g) {
                if (!UIUtil.isUnderDefaultMacTheme()) {
                    return;
                }
                Icon icon = LafIconLookup.getIcon((String)"comboRight", (boolean)false, (boolean)false, (boolean)MacIntelliJComboBoxUI.this.comboBox.isEnabled(), (boolean)MacIntelliJComboBoxUI.this.comboBox.isEditable());
                if (this.getWidth() != icon.getIconWidth() || this.getHeight() != icon.getIconHeight()) {
                    Image image = IconUtil.toImage((Icon)icon);
                    UIUtil.drawImage((Graphics)g, (Image)image, (Rectangle)new Rectangle(0, 0, this.getWidth(), this.getHeight()), null);
                } else {
                    icon.paintIcon(this, g, 0, 0);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                Icon icon = MacIntelliJComboBoxUI.this.comboBox.isEditable() ? EDITABLE_ICON : ICON;
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
        };
        button2.setBorder(BorderFactory.createEmptyBorder());
        button2.setOpaque(false);
        return button2;
    }

    @Override
    protected Dimension getSizeWithButton(Dimension size, Dimension editorSize) {
        Insets i = this.comboBox.getInsets();
        Icon icon = this.comboBox.isEditable() ? EDITABLE_ICON : ICON;
        int iconWidth = icon.getIconWidth() + i.right;
        int iconHeight = icon.getIconHeight() + i.top + i.bottom;
        int editorHeight = editorSize != null ? editorSize.height + i.top + i.bottom + this.padding.top + this.padding.bottom : 0;
        int editorWidth = editorSize != null ? editorSize.width + i.left + this.padding.left + this.padding.right : 0;
        editorWidth = Math.max(editorWidth, DarculaUIUtil.MINIMUM_WIDTH.get() + i.left);
        int width = size != null ? size.width : 0;
        int height = size != null ? size.height : 0;
        width = Math.max(width + this.padding.left, editorWidth + iconWidth);
        height = Math.max(Math.max(iconHeight, height), editorHeight);
        return new Dimension(width, height);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                if (MacIntelliJComboBoxUI.this.arrowButton != null) {
                    Rectangle bounds2 = cb.getBounds();
                    Insets cbInsets = cb.getInsets();
                    Dimension prefSize = MacIntelliJComboBoxUI.this.arrowButton.getPreferredSize();
                    int buttonHeight = bounds2.height - (cbInsets.top + cbInsets.bottom);
                    double ar = (double)buttonHeight / (double)prefSize.height;
                    int buttonWidth = (int)Math.floor((double)prefSize.width * ar);
                    int offset = (int)Math.round(ar - 1.0);
                    MacIntelliJComboBoxUI.this.arrowButton.setBounds(bounds2.width - buttonWidth - cbInsets.right + offset, cbInsets.top, buttonWidth, buttonHeight);
                }
                MacIntelliJComboBoxUI.this.layoutEditor();
            }
        };
    }

    @Override
    protected ComboPopup createPopup() {
        if (this.comboBox.getClientProperty("ComboBox.jbPopup") != null) {
            return new DarculaJBPopupComboPopup<Object>(this.comboBox){

                @Override
                protected void configureList(@NotNull JList<Object> list2) {
                    if (list2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    super.configureList(list2);
                    list2.setSelectionBackground((Color)new JBColor(() -> ColorUtil.withAlpha((Color)UIManager.getColor("ComboBox.selectionBackground"), (double)0.75)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/ui/laf/intellij/MacIntelliJComboBoxUI$3", "configureList"));
                }
            };
        }
        return new DarculaComboBoxUI.CustomComboPopup(this.comboBox){

            @Override
            protected void configureList() {
                super.configureList();
                this.list.setSelectionBackground((Color)new JBColor(() -> ColorUtil.withAlpha((Color)UIManager.getColor("ComboBox.selectionBackground"), (double)0.75)));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c2) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(c2.getSize());
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            Object value = this.comboBox.getSelectedItem();
            boolean editable = this.comboBox.isEnabled() && this.editor != null && this.comboBox.isEditable();
            Color background0 = this.comboBox.getBackground();
            Color background = editable ? this.editor.getBackground() : (this.comboBox.isBackgroundSet() && !(background0 instanceof UIResource) ? background0 : (!this.comboBox.isEnabled() ? UIManager.getColor("ComboBox.disabledBackground") : (Color)ObjectUtils.notNull((Object)(value instanceof ColoredItem ? ((ColoredItem)value).getColor() : null), (Object)UIManager.getColor("ComboBox.background"))));
            g2.setColor(background);
            float arc = this.comboBox.isEditable() ? 0.0f : MacIntelliJTextBorder.ARC.getFloat();
            float bw = MacIntelliJTextBorder.BW.getFloat();
            Area bgs = new Area(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
            bgs.subtract(new Area(this.arrowButton.getBounds()));
            g2.fill(bgs);
        }
        finally {
            g2.dispose();
        }
        if (!this.comboBox.isEditable()) {
            this.listBox.setForeground(this.comboBox.isEnabled() ? UIManager.getColor("Label.foreground") : UIManager.getColor("Label.disabledForeground"));
            this.checkFocus();
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), this.hasFocus);
        }
    }

    @Nullable
    Rectangle getArrowButtonBounds() {
        return this.arrowButton != null ? this.arrowButton.getBounds() : null;
    }
}

