/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VerticalLayout
extends AbstractLayoutManager {
    public static final String FILL_HORIZONTAL = "fill_h";
    private final int myOffset;
    private final int myWidth;
    private final Set<Component> myFillComponents = new HashSet<Component>();
    private final Map<Component, Integer> myMaxComponents = new HashMap<Component, Integer>();

    public VerticalLayout(int offset) {
        this(offset, 0);
    }

    public VerticalLayout(int offset, int width) {
        this.myOffset = offset;
        this.myWidth = width;
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (FILL_HORIZONTAL.equals(constraints)) {
            this.myFillComponents.add(component);
        } else if (constraints instanceof Integer) {
            this.myMaxComponents.put(component, (Integer)constraints);
        }
    }

    public void removeLayoutComponent(Component component) {
        this.myFillComponents.remove(component);
    }

    public Dimension preferredLayoutSize(Container parent) {
        int width = 0;
        int height = 0;
        int count = parent.getComponentCount();
        int visibleCount = 0;
        for (int i = 0; i < count; ++i) {
            Component component = parent.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension size = component.getPreferredSize();
            width = Math.max(width, size.width);
            height += size.height;
            ++visibleCount;
        }
        if (visibleCount > 1) {
            height += (visibleCount - 1) * this.myOffset;
        }
        Dimension size = new Dimension(this.myWidth > 0 ? this.myWidth : width, height);
        JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
        return size;
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - insets.left - insets.right;
        int y = insets.top;
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            int componentWidth;
            Component component = parent.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension size = component.getPreferredSize();
            if (this.myFillComponents.contains(component)) {
                componentWidth = width;
            } else {
                componentWidth = Math.min(width, size.width);
                Integer maxWidth = this.myMaxComponents.get(component);
                if (maxWidth != null) {
                    componentWidth = Math.min(componentWidth, maxWidth);
                }
            }
            component.setBounds(insets.left, y, componentWidth, size.height);
            y += size.height + this.myOffset;
        }
    }
}

