/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.DirectoryPathMatcher;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.DefaultFileNavigationContributor;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.GotoFileItemProvider");
    private final Project myProject;
    private final GotoFileModel myModel;

    public GotoFileItemProvider(@NotNull Project project, @Nullable PsiElement context, GotoFileModel model2) {
        if (project == null) {
            GotoFileItemProvider.$$$reportNull$$$0(0);
        }
        super(context);
        this.myProject = project;
        this.myModel = model2;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(4);
        }
        return (Boolean)ProgressManager.getInstance().computePrioritized(() -> this.doFilterElements(base, parameters, indicator, consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFilterElements(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(5);
        }
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(8);
        }
        long start2 = System.currentTimeMillis();
        try {
            String pattern = parameters.getCompletePattern();
            PsiFileSystemItem absolute = this.getFileByAbsolutePath(pattern);
            if (absolute != null && !consumer.process((Object)absolute)) {
                boolean bl = true;
                return bl;
            }
            if (pattern.startsWith("./") || pattern.startsWith(".\\")) {
                parameters = parameters.withCompletePattern(pattern.substring(1));
            }
            if (!this.processItemsForPattern(base, parameters, consumer, indicator)) {
                boolean bl = false;
                return bl;
            }
            String fixedPattern = FixingLayoutMatcher.fixLayout((String)pattern);
            boolean bl = fixedPattern == null || this.processItemsForPattern(base, parameters.withCompletePattern(fixedPattern), consumer, indicator);
            return bl;
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Goto File \"" + parameters.getCompletePattern() + "\" took " + (System.currentTimeMillis() - start2) + " ms");
            }
        }
    }

    private boolean processItemsForPattern(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters, @NotNull Processor<Object> consumer, @NotNull ProgressIndicator indicator) {
        int index;
        if (base == null) {
            GotoFileItemProvider.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            GotoFileItemProvider.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(12);
        }
        String sanitized = GotoFileItemProvider.getSanitizedPattern(parameters.getCompletePattern(), this.myModel);
        int qualifierEnd = sanitized.lastIndexOf(47) + 1;
        NameGrouper grouper = new NameGrouper(sanitized.substring(qualifierEnd), indicator);
        this.processNames(FindSymbolParameters.simple(this.myProject, true), (Processor<? super String>)((Processor)grouper::processName));
        Ref hasSuggestions = Ref.create((Object)false);
        for (DirectoryPathMatcher dirMatcher = DirectoryPathMatcher.root(this.myModel, sanitized.substring(0, qualifierEnd)); dirMatcher != null; dirMatcher = dirMatcher.appendChar(grouper.namePattern.charAt(index))) {
            index = grouper.index;
            SuffixMatches group = grouper.nextGroup(base);
            if (group == null) break;
            if (group.processFiles(parameters.withLocalPattern(dirMatcher.dirPattern), consumer, (Ref<Boolean>)hasSuggestions, dirMatcher)) continue;
            return false;
        }
        return true;
    }

    private void processNames(@NotNull FindSymbolParameters parameters, @NotNull Processor<? super String> nameProcessor) {
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(13);
        }
        if (nameProcessor == null) {
            GotoFileItemProvider.$$$reportNull$$$0(14);
        }
        List contributors = DumbService.getDumbAwareExtensions((Project)this.myProject, (ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME);
        for (ChooseByNameContributor contributor : contributors) {
            if (contributor instanceof DefaultFileNavigationContributor) {
                FilenameIndex.processAllFileNames(nameProcessor, parameters.getSearchScope(), parameters.getIdFilter());
                continue;
            }
            this.myModel.processContributorNames(contributor, parameters, nameProcessor);
        }
    }

    @NotNull
    public static String getSanitizedPattern(@NotNull String pattern, GotoFileModel model2) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(15);
        }
        String string = GotoFileItemProvider.removeSlashes(StringUtil.replace((String)ChooseByNamePopup.getTransformedPattern(pattern, model2), (String)"\\", (String)"/"));
        if (string == null) {
            GotoFileItemProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static MinusculeMatcher getQualifiedNameMatcher(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(17);
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)("*" + StringUtil.replace((String)StringUtil.replace((String)pattern, (String)"\\", (String)"*\\*"), (String)"/", (String)"*/*")), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(18);
        }
        return minusculeMatcher;
    }

    @NotNull
    private static String removeSlashes(String s) {
        String string = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)s, (char)'/'), (char)'/');
        if (string == null) {
            GotoFileItemProvider.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    private PsiFileSystemItem getFileByAbsolutePath(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileItemProvider.$$$reportNull$$$0(20);
        }
        if (pattern.contains("/") || pattern.contains("\\")) {
            ProjectFileIndex index;
            String path = FileUtil.toSystemIndependentName((String)ChooseByNamePopup.getTransformedPattern(pattern, this.myModel));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPathIfCached(path);
            if (vFile != null && ((index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject)).isInContent(vFile) || index.isInLibrary(vFile))) {
                return PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
            }
        }
        return null;
    }

    private Iterable<PsiFileSystemItem> matchQualifiers(MinusculeMatcher qualifierMatcher, Iterable<? extends PsiFileSystemItem> iterable) {
        HashMap<PsiFileSystemItem, Integer> qualifierMatchingDegrees = new HashMap<PsiFileSystemItem, Integer>();
        ArrayList<PsiFileSystemItem> matching2 = new ArrayList<PsiFileSystemItem>();
        for (PsiFileSystemItem psiFileSystemItem : iterable) {
            ProgressManager.checkCanceled();
            String qualifier = Objects.requireNonNull(this.getParentPath(psiFileSystemItem));
            FList fragments = qualifierMatcher.matchingFragments(qualifier);
            if (fragments == null) continue;
            matching2.add(psiFileSystemItem);
            int gapPenalty = fragments.isEmpty() ? 0 : qualifier.length() - ((TextRange)fragments.get(fragments.size() - 1)).getEndOffset();
            qualifierMatchingDegrees.put(psiFileSystemItem, -qualifierMatcher.matchingDegree(qualifier, false, fragments) + gapPenalty);
        }
        if (matching2.size() > 1) {
            Collections.sort(matching2, Comparator.comparing(qualifierMatchingDegrees::get));
        }
        return matching2;
    }

    @Nullable
    private String getParentPath(@NotNull PsiFileSystemItem item) {
        String fullName;
        if (item == null) {
            GotoFileItemProvider.$$$reportNull$$$0(21);
        }
        return (fullName = this.myModel.getFullName(item)) == null ? null : StringUtil.getPackageName((String)FileUtilRt.toSystemIndependentName((String)fullName), (char)'/') + '/';
    }

    private static JBIterable<PsiFileSystemItem> moveDirectoriesToEnd(Iterable<PsiFileSystemItem> iterable) {
        ArrayList dirs = new ArrayList();
        return JBIterable.from(iterable).filter(item -> {
            if (item instanceof PsiDirectory) {
                dirs.add(item);
                return false;
            }
            return true;
        }).append(dirs);
    }

    @NotNull
    private JBIterable<PsiFileSystemItem> getFilesMatchingPath(@NotNull FindSymbolParameters parameters, @NotNull List<String> fileNames, @NotNull DirectoryPathMatcher dirMatcher, @NotNull ProgressIndicator indicator) {
        if (parameters == null) {
            GotoFileItemProvider.$$$reportNull$$$0(22);
        }
        if (fileNames == null) {
            GotoFileItemProvider.$$$reportNull$$$0(23);
        }
        if (dirMatcher == null) {
            GotoFileItemProvider.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(25);
        }
        GlobalSearchScope scope = dirMatcher.narrowDown(parameters.getSearchScope());
        FindSymbolParameters adjusted = parameters.withScope(scope);
        List<List<String>> sortedNames = GotoFileItemProvider.sortAndGroup(fileNames, Comparator.comparing(n -> StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)n))));
        JBIterable jBIterable = JBIterable.from(sortedNames).flatMap(nameGroup -> this.getItemsForNames(indicator, adjusted, (List<String>)nameGroup));
        if (jBIterable == null) {
            GotoFileItemProvider.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    private Iterable<PsiFileSystemItem> getItemsForNames(@NotNull ProgressIndicator indicator, FindSymbolParameters parameters, List<String> fileNames) {
        if (indicator == null) {
            GotoFileItemProvider.$$$reportNull$$$0(27);
        }
        ArrayList<PsiFileSystemItem> group = new ArrayList<PsiFileSystemItem>();
        HashMap<PsiFileSystemItem, Integer> nesting = new HashMap<PsiFileSystemItem, Integer>();
        for (String fileName2 : fileNames) {
            ProgressManager.checkCanceled();
            for (Object o : this.myModel.getElementsByName(fileName2, parameters, indicator)) {
                String qualifier;
                ProgressManager.checkCanceled();
                if (!(o instanceof PsiFileSystemItem) || (qualifier = this.getParentPath((PsiFileSystemItem)o)) == null) continue;
                group.add((PsiFileSystemItem)o);
                nesting.put((PsiFileSystemItem)o, StringUtil.countChars((CharSequence)qualifier, (char)'/'));
            }
        }
        if (group.size() > 1) {
            Collections.sort(group, Comparator.comparing(nesting::get).thenComparing(this.getPathProximityComparator()).thenComparing(this.myModel::getFullName));
        }
        return group;
    }

    private static int findMatchStartingPosition(String candidateName, String namePattern) {
        int namePos = candidateName.length();
        for (int i = namePattern.length(); i > 0; --i) {
            char c2 = namePattern.charAt(i - 1);
            if (!Character.isLetterOrDigit(c2) || (namePos = StringUtil.lastIndexOfIgnoreCase((String)candidateName, (char)c2, (int)(namePos - 1))) >= 0) continue;
            return i;
        }
        return 0;
    }

    private static <T> List<List<T>> sortAndGroup(@NotNull List<T> items, @NotNull Comparator<? super T> comparator2) {
        if (items == null) {
            GotoFileItemProvider.$$$reportNull$$$0(28);
        }
        if (comparator2 == null) {
            GotoFileItemProvider.$$$reportNull$$$0(29);
        }
        return ((StreamEx)StreamEx.of(items).sorted(comparator2)).groupRuns((n1, n2) -> comparator2.compare(n1, n2) == 0).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProcessor";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirMatcher";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedPattern";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameMatcher";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSlashes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesMatchingPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFilterElements";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processItemsForPattern";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSanitizedPattern";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 26: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatcher";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFileByAbsolutePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFilesMatchingPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getItemsForNames";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sortAndGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SuffixMatches {
        final String patternSuffix;
        final MinusculeMatcher matcher;
        final List<MatchResult> matchingNames;
        final ProgressIndicator indicator;

        SuffixMatches(String pattern, @NotNull int from, ProgressIndicator indicator) {
            if (indicator == null) {
                SuffixMatches.$$$reportNull$$$0(0);
            }
            this.matchingNames = new ArrayList<MatchResult>();
            this.patternSuffix = pattern.substring(from);
            this.matcher = NameUtil.buildMatcher((String)((from > 0 ? " " : "*") + this.patternSuffix), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            this.indicator = indicator;
        }

        public String toString() {
            return "SuffixMatches{patternSuffix='" + this.patternSuffix + '\'' + ", matchingNames=" + this.matchingNames + '}';
        }

        boolean matchName(@NotNull ChooseByNameBase base, String name) {
            MatchResult result2;
            if (base == null) {
                SuffixMatches.$$$reportNull$$$0(1);
            }
            if ((result2 = GotoFileItemProvider.matches(base, this.patternSuffix, this.matcher, name)) != null) {
                this.matchingNames.add(result2);
                return true;
            }
            return false;
        }

        boolean processFiles(@NotNull FindSymbolParameters parameters, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull Ref<Boolean> hasSuggestions, @NotNull DirectoryPathMatcher dirMatcher) {
            Set<String> existingNames;
            if (parameters == null) {
                SuffixMatches.$$$reportNull$$$0(2);
            }
            if (processor2 == null) {
                SuffixMatches.$$$reportNull$$$0(3);
            }
            if (hasSuggestions == null) {
                SuffixMatches.$$$reportNull$$$0(4);
            }
            if (dirMatcher == null) {
                SuffixMatches.$$$reportNull$$$0(5);
            }
            MinusculeMatcher qualifierMatcher = GotoFileItemProvider.getQualifiedNameMatcher(parameters.getLocalPatternName());
            List matchingNames = this.matchingNames;
            if (this.patternSuffix.length() <= 3 && !dirMatcher.dirPattern.isEmpty() && (existingNames = dirMatcher.findFileNamesMatchingIfCheap(this.patternSuffix.charAt(0), this.matcher)) != null) {
                matchingNames = ContainerUtil.filter(matchingNames, mr -> existingNames.contains(mr.elementName));
            }
            List<List<String>> groups = this.groupByMatchingDegree(!parameters.getCompletePattern().startsWith("*"), matchingNames);
            for (List<String> group : groups) {
                Processor trackingProcessor;
                Object files2 = GotoFileItemProvider.this.getFilesMatchingPath(parameters, group, dirMatcher, this.indicator);
                if (!parameters.getLocalPatternName().isEmpty()) {
                    files2 = GotoFileItemProvider.this.matchQualifiers(qualifierMatcher, (Iterable)files2);
                }
                if (ContainerUtil.process((Iterable)(files2 = GotoFileItemProvider.moveDirectoriesToEnd((Iterable)files2)), (Processor)(trackingProcessor = f -> {
                    hasSuggestions.set((Object)true);
                    return processor2.process(f);
                }))) continue;
                return false;
            }
            return (Boolean)hasSuggestions.get() != false || parameters.isSearchInLibraries() || !this.hasSuggestionsOutsideProject(parameters.getCompletePattern(), groups, dirMatcher);
        }

        private boolean hasSuggestionsOutsideProject(@NotNull String pattern, @NotNull List<? extends List<String>> groups, @NotNull DirectoryPathMatcher dirMatcher) {
            if (pattern == null) {
                SuffixMatches.$$$reportNull$$$0(6);
            }
            if (groups == null) {
                SuffixMatches.$$$reportNull$$$0(7);
            }
            if (dirMatcher == null) {
                SuffixMatches.$$$reportNull$$$0(8);
            }
            return ContainerUtil.exists(groups, group -> !GotoFileItemProvider.this.getFilesMatchingPath(FindSymbolParameters.wrap(pattern, GotoFileItemProvider.this.myProject, true), group, dirMatcher, this.indicator).isEmpty());
        }

        private List<List<String>> groupByMatchingDegree(boolean preferStartMatches, List<? extends MatchResult> matchingNames) {
            Comparator comparator2 = (mr1, mr2) -> {
                boolean exactPrefix1 = StringUtil.startsWith((CharSequence)mr1.elementName, (CharSequence)this.patternSuffix);
                boolean exactPrefix2 = StringUtil.startsWith((CharSequence)mr2.elementName, (CharSequence)this.patternSuffix);
                if (exactPrefix1 && exactPrefix2) {
                    return 0;
                }
                if (exactPrefix1 != exactPrefix2) {
                    return exactPrefix1 ? -1 : 1;
                }
                return mr1.compareDegrees((MatchResult)mr2, preferStartMatches);
            };
            return ContainerUtil.map((Collection)GotoFileItemProvider.sortAndGroup(matchingNames, comparator2), mrs -> ContainerUtil.map((Collection)mrs, mr -> mr.elementName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "base";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasSuggestions";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirMatcher";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/GotoFileItemProvider$SuffixMatches";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFiles";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasSuggestionsOutsideProject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NameGrouper {
        private final String namePattern;
        @NotNull
        private final ProgressIndicator indicator;
        private final List<List<String>> candidateNames;
        private int index;

        NameGrouper(@NotNull String namePattern, ProgressIndicator indicator) {
            if (namePattern == null) {
                NameGrouper.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                NameGrouper.$$$reportNull$$$0(1);
            }
            this.namePattern = namePattern;
            this.candidateNames = IntStreamEx.range((int)0, (int)namePattern.length()).mapToObj(__ -> new ArrayList()).toList();
            this.indicator = indicator;
        }

        boolean processName(String name) {
            this.indicator.checkCanceled();
            int position = GotoFileItemProvider.findMatchStartingPosition(name, this.namePattern);
            if (position < this.namePattern.length()) {
                this.candidateNames.get(position).add(name);
            }
            return true;
        }

        @Nullable
        SuffixMatches nextGroup(ChooseByNameBase base) {
            if (this.index >= this.namePattern.length()) {
                return null;
            }
            SuffixMatches matches = new SuffixMatches(this.namePattern, this.index, this.indicator);
            for (String name : this.candidateNames.get(this.index)) {
                if (matches.matchName(base, name) || this.index + 1 >= this.namePattern.length()) continue;
                this.candidateNames.get(this.index + 1).add(name);
            }
            this.candidateNames.set(this.index, null);
            ++this.index;
            return matches;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namePattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/GotoFileItemProvider$NameGrouper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

