/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateDirectoryHandler;
import com.intellij.ide.actions.CreateGroupHandler;
import com.intellij.ide.actions.CreatePackageHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class CreateDirectoryOrPackageAction
extends AnAction
implements DumbAware {
    public CreateDirectoryOrPackageAction() {
        super(IdeBundle.message((String)"action.create.new.directory.or.package", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.directory.or.package", (Object[])new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String title;
        String message;
        CreateGroupHandler validator;
        if (event == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(0);
        }
        IdeView view = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (view == null || project == null) {
            return;
        }
        PsiDirectory directory = DirectoryChooserUtil.getOrChooseDirectory(view);
        if (directory == null) {
            return;
        }
        if (PsiDirectoryFactory.getInstance(project).isPackage(directory)) {
            validator = new CreatePackageHandler(project, directory);
            message = IdeBundle.message((String)"prompt.enter.new.package.name", (Object[])new Object[0]);
            title = IdeBundle.message((String)"title.new.package", (Object[])new Object[0]);
        } else {
            validator = new CreateDirectoryHandler(project, directory);
            message = IdeBundle.message((String)"prompt.enter.new.directory.name", (Object[])new Object[0]);
            title = IdeBundle.message((String)"title.new.directory", (Object[])new Object[0]);
        }
        String initialText = validator.getInitialText();
        Messages.showInputDialog((Project)project, (String)message, (String)title, null, (String)initialText, (InputValidator)validator, (TextRange)TextRange.from((int)initialText.length(), (int)0));
        PsiFileSystemItem result2 = validator.getCreatedElement();
        if (result2 != null) {
            view.selectElement((PsiElement)result2);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CreateDirectoryOrPackageAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        IdeView view = (IdeView)event.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        boolean isPackage = false;
        PsiDirectoryFactory factory = PsiDirectoryFactory.getInstance(project);
        for (PsiDirectory directory : directories) {
            if (!factory.isPackage(directory)) continue;
            isPackage = true;
            break;
        }
        if (isPackage) {
            presentation.setText(IdeBundle.message((String)"action.package", (Object[])new Object[0]));
            presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        } else {
            presentation.setText(IdeBundle.message((String)"action.directory", (Object[])new Object[0]));
            presentation.setIcon(PlatformIcons.FOLDER_ICON);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/ide/actions/CreateDirectoryOrPackageAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

