/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyReferenceFQNTransferable;
import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.ide.actions.CopyTBXReferenceAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.IoKt;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/actions/CopyTBXReferenceAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.platform.lang.impl"})
public final class CopyTBXReferenceAction
extends DumbAwareAction {
    private static final Logger LOG;
    private static final String JETBRAINS_NAVIGATE = "jetbrains://";
    private static final Map<String, String> IDE_TAGS;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!Registry.is((String)"copy.tbx.reference.enabled")) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean plural = false;
        boolean enabled = false;
        boolean paths = false;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        DataContext dataContext2 = dataContext;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null) {
            enabled = true;
        } else {
            List<PsiElement> list2 = CopyReferenceUtil.getElementsToCopy(editor, dataContext2);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"getElementsToCopy(editor, dataContext)");
            List<PsiElement> elements2 = list2;
            enabled = !elements2.isEmpty();
            plural = elements2.size() > 1;
            paths = elements2.stream().allMatch(update.1.INSTANCE);
        }
        enabled = enabled && Intrinsics.areEqual((Object)"MainMenu", (Object)e.getPlace());
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setVisible(enabled);
        } else {
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
            presentation3.setVisible(true);
        }
        Presentation presentation4 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"e.presentation");
        presentation4.setText(paths ? (plural ? "Cop&y Toolbox Relative Paths URL" : "Cop&y Toolbox Relative Path URL") : (plural ? "Cop&y Toolbox References URL" : "Cop&y Toolbox Reference URL"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        DataContext dataContext2 = dataContext;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        List<PsiElement> list2 = CopyReferenceUtil.getElementsToCopy(editor, dataContext2);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"getElementsToCopy(editor, dataContext)");
        List<PsiElement> elements2 = list2;
        if (project == null) {
            LOG.warn("'Copy TBX Reference' action cannot find project.");
            return;
        }
        String copy = Companion.createJetbrainsLink(project, elements2, editor);
        if (copy != null) {
            CopyPasteManager.getInstance().setContents((Transferable)new CopyReferenceFQNTransferable(copy));
            CopyReferenceUtil.setStatusBarText(project, IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{copy}));
        } else if (editor != null) {
            Document document = editor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            Document document2 = document;
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document2);
            if (file2 != null) {
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                LogicalPosition logicalPosition = caretModel.getLogicalPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"editor.caretModel.logicalPosition");
                LogicalPosition logicalPosition2 = logicalPosition;
                String path = CopyReferenceUtil.getFileFqn(file2) + ':' + (logicalPosition2.line + 1) + ':' + (logicalPosition2.column + 1);
                copy = CopyTBXReferenceAction.Companion.createLink(editor, project, CopyTBXReferenceAction.Companion.createRefs(true, path, ""));
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(copy));
                CopyReferenceUtil.setStatusBarText(project, copy + " has been copied");
            }
            return;
        }
        CopyReferenceUtil.highlight(editor, project, elements2);
    }

    public CopyTBXReferenceAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(CopyTBXReferenceAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(CopyT\u2026erenceAction::class.java)");
        LOG = logger;
        IDE_TAGS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"idea", (Object)"idea"), TuplesKt.to((Object)"Idea", (Object)"idea"), TuplesKt.to((Object)"AppCode", (Object)"appcode"), TuplesKt.to((Object)"CLion", (Object)"clion"), TuplesKt.to((Object)"Python", (Object)"pycharm"), TuplesKt.to((Object)"PyCharmCore", (Object)"pycharm"), TuplesKt.to((Object)"PyCharmEdu", (Object)"pycharm"), TuplesKt.to((Object)"PhpStorm", (Object)"php-storm"), TuplesKt.to((Object)"Ruby", (Object)"rubymine"), TuplesKt.to((Object)"WebStorm", (Object)"web-storm"), TuplesKt.to((Object)"Rider", (Object)"rd"), TuplesKt.to((Object)"GoLand", (Object)"goland")});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J&\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ide/actions/CopyTBXReferenceAction$Companion;", "", "()V", "IDE_TAGS", "", "", "JETBRAINS_NAVIGATE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createJetbrainsLink", "project", "Lcom/intellij/openapi/project/Project;", "elements", "", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createLink", "refsParameters", "createRefs", "isFile", "", "reference", "index", "getSelectionParameters", "caret", "Lcom/intellij/openapi/editor/Caret;", "getSelectionRange", "element", "parameterIndex", "", "size", "intellij.platform.lang.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String createJetbrainsLink(@NotNull Project project, @NotNull List<? extends PsiElement> elements2, @Nullable Editor editor) {
            void $this$mapValuesTo$iv$iv;
            Map $this$filterTo$iv$iv;
            void $this$associateByTo$iv$iv;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
            int n = elements2.size();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                void i;
                int n3 = n2;
                int n4 = n2++;
                object = nArray;
                boolean bl = false;
                void var22_15 = i;
                object[n4] = var22_15;
            }
            int[] $this$associateBy$iv = nArray;
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
            int[] i = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo22 = false;
            void var11_25 = $this$associateByTo$iv$iv;
            int n5 = ((void)var11_25).length;
            for (int j = 0; j < n5; ++j) {
                void it;
                void element$iv$iv;
                void var15_35 = element$iv$iv = var11_25[j];
                object = destination$iv$iv;
                boolean bl = false;
                Integer n6 = (int)it;
                it = element$iv$iv;
                boolean bl2 = false;
                String string = CopyReferenceUtil.elementToFqn(elements2.get((int)it), editor);
                object.put(n6, string);
            }
            Map $this$filter$iv = destination$iv$iv;
            boolean $i$f$filter = false;
            Map capacity$iv22 = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void $i$f$associateByTo22 = $this$filterTo$iv$iv;
            boolean bl = false;
            Iterator iterator = $i$f$associateByTo22.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it2 = element$iv$iv = iterator.next();
                boolean bl3 = false;
                if (!(it2.getValue() != null)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$mapValues$iv = destination$iv$iv2;
            boolean $i$f$mapValues = false;
            $this$filterTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            iterator = $this$associateByTo$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                void it$iv$iv;
                Map.Entry element$iv$iv$iv;
                Map.Entry it2 = element$iv$iv$iv = iterator.next();
                Map map2 = destination$iv$iv2;
                boolean bl4 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry = element$iv$iv$iv;
                Object k2 = k;
                object = map2;
                boolean bl5 = false;
                String string = FileUtil.getLocationRelativeToUserHome((String)((String)it.getValue()), (boolean)false);
                object.put(k2, string);
            }
            Collection collection = destination$iv$iv2.entrySet();
            boolean bl6 = false;
            if (collection.isEmpty()) {
                boolean bl7 = false;
                return null;
            }
            String refsParameters2 = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends Integer, ? extends String>, String>(elements2){
                final /* synthetic */ List $elements;

                @NotNull
                public final String invoke(@NotNull Map.Entry<Integer, String> it) {
                    String string;
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    if (this.$elements.size() > 1) {
                        String string2 = it.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.value");
                        string = IoKt.encodeUrlQueryParameter((String)string2);
                    } else {
                        string = it.getValue();
                    }
                    String reference2 = string;
                    return com.intellij.ide.actions.CopyTBXReferenceAction$Companion.access$createRefs(CopyTBXReferenceAction.Companion, com.intellij.ide.actions.CopyTBXReferenceAction$Companion.access$isFile(CopyTBXReferenceAction.Companion, (PsiElement)this.$elements.get(((Number)it.getKey()).intValue())), reference2, com.intellij.ide.actions.CopyTBXReferenceAction$Companion.access$parameterIndex(CopyTBXReferenceAction.Companion, ((Number)it.getKey()).intValue(), this.$elements.size()));
                }
                {
                    this.$elements = list2;
                    super(1);
                }
            }), (int)30, null);
            return this.createLink(editor, project, refsParameters2);
        }

        private final boolean isFile(PsiElement element) {
            return element instanceof PsiFileSystemItem && CopyReferenceUtil.getQualifiedNameFromProviders(element) == null;
        }

        private final String parameterIndex(int index, int size) {
            return size == 1 ? "" : String.valueOf(index + 1);
        }

        private final String createRefs(boolean isFile, String reference2, String index) {
            return '&' + (isFile ? "path" : "fqn") + index + '=' + reference2;
        }

        private final String createLink(Editor editor, Project project, String refsParameters2) {
            String tool = (String)IDE_TAGS.get(PlatformUtils.getPlatformPrefix());
            if (tool == null) {
                LOG.warn("Cannot find TBX tool for IDE: " + PlatformUtils.getPlatformPrefix());
                return null;
            }
            String string = this.getSelectionParameters(editor);
            if (string == null) {
                string = "";
            }
            String selectionParameters = string;
            String projectParameter = "project=" + project.getName();
            return CopyTBXReferenceAction.JETBRAINS_NAVIGATE + tool + "/navigate/reference?" + projectParameter + refsParameters2 + selectionParameters;
        }

        private final String getSelectionParameters(Editor editor) {
            if (editor == null) {
                return null;
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (editor.getCaretModel().supportsMultipleCarets()) {
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                List list2 = caretModel.getAllCarets();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"editor.caretModel.allCarets");
                List carets = list2;
                return IntStream.range(0, carets.size()).mapToObj((IntFunction)new IntFunction<String>(editor, carets){
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ List $carets;

                    @Nullable
                    public final String apply(int i) {
                        E e = this.$carets.get(i);
                        Intrinsics.checkExpressionValueIsNotNull(e, (String)"carets[i]");
                        return com.intellij.ide.actions.CopyTBXReferenceAction$Companion.access$getSelectionParameters(CopyTBXReferenceAction.Companion, this.$editor, (Caret)e, com.intellij.ide.actions.CopyTBXReferenceAction$Companion.access$parameterIndex(CopyTBXReferenceAction.Companion, i, this.$carets.size()));
                    }
                    {
                        this.$editor = editor;
                        this.$carets = list2;
                    }
                }).filter(getSelectionParameters.2.INSTANCE).collect(Collectors.joining());
            }
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            Caret caret = caretModel.getCurrentCaret();
            Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"editor.caretModel.currentCaret");
            return this.getSelectionParameters(editor, caret, "");
        }

        private final String getSelectionParameters(Editor editor, Caret caret, String index) {
            String string;
            String string2 = this.getSelectionRange(editor, caret);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string = "&selection" + index + '=' + it;
            } else {
                string = null;
            }
            return string;
        }

        private final String getSelectionRange(Editor editor, Caret caret) {
            if (!caret.hasSelection()) {
                return null;
            }
            LogicalPosition logicalPosition = editor.visualToLogicalPosition(caret.getSelectionStartPosition());
            Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"editor.visualToLogicalPo\u2026t.selectionStartPosition)");
            LogicalPosition selectionStart = logicalPosition;
            LogicalPosition logicalPosition2 = editor.visualToLogicalPosition(caret.getSelectionEndPosition());
            Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition2, (String)"editor.visualToLogicalPo\u2026ret.selectionEndPosition)");
            LogicalPosition selectionEnd = logicalPosition2;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%d:%d-%d:%d";
            Object[] objectArray = new Object[]{selectionStart.line + 1, selectionStart.column + 1, selectionEnd.line + 1, selectionEnd.column + 1};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isFile(Companion $this, PsiElement element) {
            return $this.isFile(element);
        }

        public static final /* synthetic */ String access$parameterIndex(Companion $this, int index, int size) {
            return $this.parameterIndex(index, size);
        }

        public static final /* synthetic */ String access$getSelectionParameters(Companion $this, Editor editor, Caret caret, String index) {
            return $this.getSelectionParameters(editor, caret, index);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

