/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.IndentInside;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

class FormatProcessorUtils {
    FormatProcessorUtils() {
    }

    private static int calcShift(@NotNull IndentInside oldIndent, @NotNull IndentInside newIndent, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (oldIndent == null) {
            FormatProcessorUtils.$$$reportNull$$$0(0);
        }
        if (newIndent == null) {
            FormatProcessorUtils.$$$reportNull$$$0(1);
        }
        if (options == null) {
            FormatProcessorUtils.$$$reportNull$$$0(2);
        }
        if (oldIndent.equals(newIndent)) {
            return 0;
        }
        return newIndent.getSpacesCount(options) - oldIndent.getSpacesCount(options);
    }

    static int replaceWhiteSpace(FormattingModel model2, @NotNull LeafBlockWrapper block, int shift, CharSequence _newWhiteSpace, CommonCodeStyleSettings.IndentOptions options) {
        if (block == null) {
            FormatProcessorUtils.$$$reportNull$$$0(3);
        }
        WhiteSpace whiteSpace = block.getWhiteSpace();
        TextRange textRange = whiteSpace.getTextRange();
        TextRange wsRange = textRange.shiftRight(shift);
        String newWhiteSpace = _newWhiteSpace.toString();
        TextRange newWhiteSpaceRange = model2 instanceof FormattingModelEx ? ((FormattingModelEx)model2).replaceWhiteSpace(wsRange, block.getNode(), newWhiteSpace) : model2.replaceWhiteSpace(wsRange, newWhiteSpace);
        shift += newWhiteSpaceRange.getLength() - textRange.getLength();
        if (block.isLeaf() && whiteSpace.containsLineFeeds() && block.containsLineFeeds()) {
            IndentInside whiteSpaceIndent;
            TextRange currentBlockRange = block.getTextRange().shiftRight(shift);
            IndentInside oldBlockIndent = whiteSpace.getInitialLastLineIndent();
            int shiftInside = FormatProcessorUtils.calcShift(oldBlockIndent, whiteSpaceIndent = IndentInside.createIndentOn(IndentInside.getLastLine(newWhiteSpace)), options);
            if (shiftInside != 0 || !oldBlockIndent.equals(whiteSpaceIndent)) {
                TextRange newBlockRange = model2.shiftIndentInsideRange(block.getNode(), currentBlockRange, shiftInside);
                shift += newBlockRange.getLength() - block.getLength();
            }
        }
        return shift;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldIndent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIndent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/engine/FormatProcessorUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calcShift";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

