/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLDistributionService;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLUtil {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.wsl");
    private static final ProcessListener INPUT_CLOSE_LISTENER = new ProcessAdapter(){

        public void startNotified(@NotNull ProcessEvent event) {
            OutputStream input;
            if (event == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((input = event.getProcessHandler().getProcessInput()) != null) {
                try {
                    input.flush();
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/wsl/WSLUtil$1", "startNotified"));
        }
    };

    public static boolean hasAvailableDistributions() {
        return !WSLUtil.getAvailableDistributions().isEmpty();
    }

    @NotNull
    public static List<WSLDistribution> getAvailableDistributions() {
        if (!WSLUtil.isSystemCompatible()) {
            List<WSLDistribution> list2 = Collections.emptyList();
            if (list2 == null) {
                WSLUtil.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Path executableRoot = WSLUtil.getExecutableRootPath();
        if (executableRoot == null) {
            List<WSLDistribution> list3 = Collections.emptyList();
            if (list3 == null) {
                WSLUtil.$$$reportNull$$$0(1);
            }
            return list3;
        }
        Collection<WslDistributionDescriptor> descriptors = WSLDistributionService.getInstance().getDescriptors();
        ArrayList<WSLDistribution> result2 = new ArrayList<WSLDistribution>(descriptors.size() + 1);
        for (WslDistributionDescriptor descriptor2 : descriptors) {
            Path executablePath = Paths.get(descriptor2.getExecutablePath(), new String[0]);
            if (!executablePath.isAbsolute()) {
                executablePath = executableRoot.resolve(executablePath);
            }
            if (!Files.exists(executablePath, LinkOption.NOFOLLOW_LINKS)) continue;
            result2.add(new WSLDistribution(descriptor2, executablePath));
        }
        if (Experiments.isFeatureEnabled((String)"wsl.legacy.distribution")) {
            ContainerUtil.addIfNotNull(result2, (Object)WSLDistributionLegacy.getInstance());
        }
        ArrayList<WSLDistribution> arrayList = result2;
        if (arrayList == null) {
            WSLUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    private static Path getExecutableRootPath() {
        String localAppDataPath = System.getenv().get("LOCALAPPDATA");
        return StringUtil.isEmpty((String)localAppDataPath) ? null : Paths.get(localAppDataPath, "Microsoft\\WindowsApps");
    }

    @Nullable
    public static WSLDistribution getDistributionById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        for (WSLDistribution distribution : WSLUtil.getAvailableDistributions()) {
            if (!id.equals(distribution.getId())) continue;
            return distribution;
        }
        return null;
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    @NotNull
    public static <T extends ProcessHandler> T addInputCloseListener(@NotNull T processHandler2) {
        if (processHandler2 == null) {
            WSLUtil.$$$reportNull$$$0(3);
        }
        if (Experiments.isFeatureEnabled((String)"wsl.close.process.input")) {
            processHandler2.removeProcessListener(INPUT_CLOSE_LISTENER);
            processHandler2.addProcessListener(INPUT_CLOSE_LISTENER);
        }
        T t = processHandler2;
        if (t == null) {
            WSLUtil.$$$reportNull$$$0(4);
        }
        return t;
    }

    public static boolean isSystemCompatible() {
        return SystemInfo.isWin10OrNewer;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    @Nullable
    public static String getWindowsPath(@NotNull String wslPath) {
        if (wslPath == null) {
            WSLUtil.$$$reportNull$$$0(5);
        }
        return WSLUtil.getWindowsPath(wslPath, "/mnt/");
    }

    @Nullable
    public static String getWindowsPath(@NotNull String wslPath, @NotNull String mntRoot) {
        if (wslPath == null) {
            WSLUtil.$$$reportNull$$$0(6);
        }
        if (mntRoot == null) {
            WSLUtil.$$$reportNull$$$0(7);
        }
        if (!wslPath.startsWith(mntRoot)) {
            return null;
        }
        int driveLetterIndex = mntRoot.length();
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            return null;
        }
        return FileUtil.toSystemDependentName((String)(Character.toUpperCase(wslPath.charAt(driveLetterIndex)) + ":" + wslPath.substring(slashIndex)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mntRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addInputCloseListener";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addInputCloseListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

