/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayout {
    public static final Key<Integer> DEFAULT_INDEX = Key.create((String)"RunnerLayoutDefaultIndex");
    public static final Key<Integer> DROP_INDEX = Key.create((String)"RunnerLayoutDropIndex");
    protected Map<String, ViewImpl> myViews = new LinkedHashMap();
    private final Map<String, ViewImpl.Default> myDefaultViews = new HashMap<String, ViewImpl.Default>();
    protected Set<TabImpl> myTabs = new TreeSet<TabImpl>(Comparator.comparingInt(TabImpl::getIndex));
    private final Map<Integer, TabImpl.Default> myDefaultTabs = new HashMap<Integer, TabImpl.Default>();
    protected General myGeneral = new General();
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();
    private Set<String> myLightWeightIds = null;

    @Nullable
    public String getDefaultDisplayName(int defaultIndex) {
        TabImpl.Default tab = this.myDefaultTabs.get(defaultIndex);
        return tab != null ? tab.myDisplayName : null;
    }

    @NotNull
    public TabImpl getOrCreateTab(int index) {
        if (index < 0) {
            TabImpl tabImpl = this.createNewTab();
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(0);
            }
            return tabImpl;
        }
        TabImpl tab = this.findTab(index);
        if (tab != null) {
            TabImpl tabImpl = tab;
            if (tabImpl == null) {
                RunnerLayout.$$$reportNull$$$0(1);
            }
            return tabImpl;
        }
        TabImpl tabImpl = tab = this.createNewTab(index);
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(2);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl createNewTab(int index) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        TabImpl tabImpl = tab;
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(3);
        }
        return tabImpl;
    }

    @NotNull
    private TabImpl.Default getOrCreateDefaultTab(int index) {
        TabImpl.Default tab = this.myDefaultTabs.get(index);
        if (tab == null) {
            tab = new TabImpl.Default(index, null, null);
            this.myDefaultTabs.put(index, tab);
        }
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(4);
        }
        return default_;
    }

    @NotNull
    public TabImpl createNewTab() {
        int index = this.myTabs.stream().mapToInt(x -> x.getIndex()).max().orElse(-1) + 1;
        TabImpl tabImpl = this.createNewTab(index);
        if (tabImpl == null) {
            RunnerLayout.$$$reportNull$$$0(5);
        }
        return tabImpl;
    }

    private boolean isUsed(@NotNull TabImpl tab) {
        if (tab == null) {
            RunnerLayout.$$$reportNull$$$0(6);
        }
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected TabImpl findTab(int index) {
        for (TabImpl each : this.myTabs) {
            if (index != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public Element getState() {
        Element element = this.write(new Element("layout"));
        if (element == null) {
            RunnerLayout.$$$reportNull$$$0(7);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            RunnerLayout.$$$reportNull$$$0(8);
        }
        this.read(state);
    }

    @NotNull
    public Element read(@NotNull Element parentNode) {
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(9);
        }
        List tabs = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Object eachTabElement : tabs) {
            TabImpl eachTab = (TabImpl)XmlSerializer.deserialize((Element)eachTabElement, TabImpl.class);
            XmlSerializer.deserializeInto((Element)eachTabElement, (Object)this.getOrCreateTab(eachTab.getIndex()));
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Element content2 : views) {
            ViewImpl view = new ViewImpl();
            XmlSerializer.deserializeInto((Element)content2, (Object)view);
            view.assignTab(this.getOrCreateTab(view.getTabIndex()));
            this.myViews.put(view.getID(), view);
        }
        Element general = parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$'));
        XmlSerializer.deserializeInto((Element)(general == null ? new Element("state") : general), (Object)this.myGeneral);
        Element element = parentNode;
        if (element == null) {
            RunnerLayout.$$$reportNull$$$0(10);
        }
        return element;
    }

    @NotNull
    public Element write(@NotNull Element parentNode) {
        Element element;
        if (parentNode == null) {
            RunnerLayout.$$$reportNull$$$0(11);
        }
        for (ViewImpl eachState : this.myViews.values()) {
            if (this.myLightWeightIds != null && this.myLightWeightIds.contains(eachState.getID())) continue;
            element = XmlSerializer.serialize((Object)eachState);
            parentNode.addContent(element == null ? new Element("ViewImpl") : element);
        }
        for (TabImpl eachTab : this.myTabs) {
            if (!this.isUsed(eachTab)) continue;
            element = XmlSerializer.serialize((Object)eachTab);
            parentNode.addContent(element == null ? new Element("TabImpl") : element);
        }
        Element generalContent = XmlSerializer.serialize((Object)this.myGeneral);
        if (generalContent != null) {
            parentNode.addContent(generalContent);
        }
        Element element2 = parentNode;
        if (element2 == null) {
            RunnerLayout.$$$reportNull$$$0(12);
        }
        return element2;
    }

    public void resetToDefault() {
        this.myViews.clear();
        this.myTabs.clear();
    }

    public boolean isToolbarHorizontal() {
        return false;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myGeneral.horizontalToolbar = horizontal;
    }

    @NotNull
    public ViewImpl getStateFor(@NotNull Content content2) {
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(13);
        }
        ViewImpl viewImpl = this.getOrCreateView(RunnerLayout.getOrCreateContentId(content2));
        if (viewImpl == null) {
            RunnerLayout.$$$reportNull$$$0(14);
        }
        return viewImpl;
    }

    public void clearStateFor(@NotNull Content content2) {
        Tab tab;
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(15);
        }
        String id = RunnerLayout.getOrCreateContentId(content2);
        this.myDefaultViews.remove(id);
        ViewImpl view = this.myViews.remove(id);
        if (view != null && (tab = view.getTab()) instanceof TabImpl) {
            this.myTabs.remove(tab);
        }
    }

    @NotNull
    private static String getOrCreateContentId(@NotNull Content content2) {
        String id;
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(16);
        }
        if ((id = (String)content2.getUserData(ViewImpl.ID)) == null) {
            id = "UnknownView-" + content2.getDisplayName();
            content2.putUserData(ViewImpl.ID, (Object)id);
        }
        String string = id;
        if (string == null) {
            RunnerLayout.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private ViewImpl getOrCreateView(@NotNull String id) {
        ViewImpl view;
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(18);
        }
        if ((view = this.myViews.get(id)) == null) {
            view = this.getOrCreateDefault(id).createView(this);
            this.myViews.put(id, view);
        }
        ViewImpl viewImpl = view;
        if (viewImpl == null) {
            RunnerLayout.$$$reportNull$$$0(19);
        }
        return viewImpl;
    }

    @NotNull
    private ViewImpl.Default getOrCreateDefault(@NotNull String id) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(20);
        }
        if (this.myDefaultViews.containsKey(id)) {
            ViewImpl.Default default_ = this.myDefaultViews.get(id);
            if (default_ == null) {
                RunnerLayout.$$$reportNull$$$0(21);
            }
            return default_;
        }
        ViewImpl.Default default_ = this.setDefault(id, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(22);
        }
        return default_;
    }

    @NotNull
    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon);
        this.myDefaultTabs.put(tabID, tab);
        TabImpl.Default default_ = tab;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(23);
        }
        return default_;
    }

    @NotNull
    public ViewImpl.Default setDefault(@NotNull String id, int tabIndex, @NotNull PlaceInGrid placeInGrid, boolean isMinimized) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(24);
        }
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(25);
        }
        ViewImpl.Default view = new ViewImpl.Default(id, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id, view);
        ViewImpl.Default default_ = view;
        if (default_ == null) {
            RunnerLayout.$$$reportNull$$$0(26);
        }
        return default_;
    }

    @NotNull
    public PlaceInGrid getDefaultGridPlace(@NotNull Content content2) {
        if (content2 == null) {
            RunnerLayout.$$$reportNull$$$0(27);
        }
        PlaceInGrid placeInGrid = this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content2)).getPlaceInGrid();
        if (placeInGrid == null) {
            RunnerLayout.$$$reportNull$$$0(28);
        }
        return placeInGrid;
    }

    public boolean isToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(29);
        }
        return Comparing.equal((String)id, (String)this.getToFocus(condition));
    }

    public void setToFocus(String id, @NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(30);
        }
        this.myGeneral.focusOnCondition.put(condition, id);
    }

    public void setDefaultToFocus(@NotNull String id, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (id == null) {
            RunnerLayout.$$$reportNull$$$0(31);
        }
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(32);
        }
        if (policy == null) {
            RunnerLayout.$$$reportNull$$$0(33);
        }
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id, (Object)policy));
    }

    void cancelDefaultFocusBy(@NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(34);
        }
        this.myDefaultFocus.remove(condition);
    }

    @Nullable
    public String getToFocus(@NotNull String condition) {
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(35);
        }
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    @NotNull
    public LayoutAttractionPolicy getAttractionPolicy(@NotNull String condition) {
        Pair<String, LayoutAttractionPolicy> pair;
        if (condition == null) {
            RunnerLayout.$$$reportNull$$$0(36);
        }
        Object object = (pair = this.myDefaultFocus.get(condition)) == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
        if (object == null) {
            RunnerLayout.$$$reportNull$$$0(37);
        }
        return object;
    }

    public void setLightWeight(Content content2) {
        if (this.myLightWeightIds == null) {
            this.myLightWeightIds = new HashSet<String>();
        }
        this.myLightWeightIds.add(RunnerLayout.getOrCreateContentId(content2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 18: 
            case 20: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInGrid";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTab";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTab";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefaultTab";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerLayout";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateFor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContentId";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateView";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDefault";
                break;
            }
            case 23: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setDefault";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGridPlace";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttractionPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStateFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clearStateFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContentId";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateView";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDefault";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setDefault";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGridPlace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isToFocus";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setToFocus";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultToFocus";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "cancelDefaultFocusBy";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getToFocus";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAttractionPolicy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class General {
        public volatile boolean horizontalToolbar = false;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
    }
}

