/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

abstract class BaseRCSettingsConfigurable
extends SettingsEditorConfigurable<RunnerAndConfigurationSettings> {
    BaseRCSettingsConfigurable(@NotNull SettingsEditor<RunnerAndConfigurationSettings> editor, @NotNull RunnerAndConfigurationSettings settings) {
        if (editor == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(1);
        }
        super(editor, (Object)settings);
    }

    public boolean isModified() {
        try {
            RunnerAndConfigurationSettings original = (RunnerAndConfigurationSettings)this.getSettings();
            RunManagerImpl runManager = ((RunnerAndConfigurationSettingsImpl)original).getManager();
            if (!original.isTemplate() && !runManager.hasSettings(original)) {
                return true;
            }
            if (!super.isModified()) {
                return false;
            }
            RunnerAndConfigurationSettings snapshot = (RunnerAndConfigurationSettings)this.getEditor().getSnapshot();
            if (this.isSnapshotSpecificallyModified(original, snapshot) || !RunManagerImplKt.doGetBeforeRunTasks(original.getConfiguration()).equals(RunManagerImplKt.doGetBeforeRunTasks(snapshot.getConfiguration()))) {
                return true;
            }
            if (original instanceof JDOMExternalizable && snapshot instanceof JDOMExternalizable) {
                boolean result2;
                this.applySnapshotToComparison(original, snapshot);
                Element originalElement = new Element("config");
                Element snapshotElement = new Element("config");
                ((JDOMExternalizable)original).writeExternal(originalElement);
                ((JDOMExternalizable)snapshot).writeExternal(snapshotElement);
                this.patchElementsIfNeeded(originalElement, snapshotElement);
                boolean bl = result2 = !JDOMUtil.areElementsEqual((Element)originalElement, (Element)snapshotElement, (boolean)true);
                if (!result2) {
                    super.setModified(false);
                }
                return result2;
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        return super.isModified();
    }

    void applySnapshotToComparison(RunnerAndConfigurationSettings original, RunnerAndConfigurationSettings snapshot) {
    }

    boolean isSnapshotSpecificallyModified(@NotNull RunnerAndConfigurationSettings original, @NotNull RunnerAndConfigurationSettings snapshot) {
        if (original == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(2);
        }
        if (snapshot == null) {
            BaseRCSettingsConfigurable.$$$reportNull$$$0(3);
        }
        return false;
    }

    void patchElementsIfNeeded(Element originalElement, Element snapshotElement) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/impl/BaseRCSettingsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSnapshotSpecificallyModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

