/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileLoadUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileProcessor;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProfileManager", storages={@Storage(value="editor.xml")}, additionalExportFile="inspection")
public class ApplicationInspectionProfileManager
extends BaseInspectionProfileManager
implements InspectionProfileManager,
PersistentStateComponent<Element> {
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledInspectionProfile");
    private final SchemeManager<InspectionProfileImpl> mySchemeManager;
    private final AtomicBoolean myProfilesAreInitialized;
    private volatile boolean LOAD_PROFILES;

    public static ApplicationInspectionProfileManager getInstanceImpl() {
        return (ApplicationInspectionProfileManager)ServiceManager.getService(InspectionProfileManager.class);
    }

    public ApplicationInspectionProfileManager() {
        this(SchemeManagerFactory.getInstance());
    }

    public ApplicationInspectionProfileManager(@NotNull SchemeManagerFactory schemeManagerFactory) {
        if (schemeManagerFactory == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(0);
        }
        super(ApplicationManager.getApplication().getMessageBus());
        this.myProfilesAreInitialized = new AtomicBoolean(false);
        this.LOAD_PROFILES = !ApplicationManager.getApplication().isUnitTestMode();
        ApplicationInspectionProfileManager.registerProvidedSeverities();
        this.mySchemeManager = schemeManagerFactory.create("inspection", new InspectionProfileProcessor(){

            @Override
            @NotNull
            public String getSchemeKey(@NotNull Function<String, String> attributeProvider, @NotNull String fileNameWithoutExtension) {
                if (attributeProvider == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fileNameWithoutExtension == null) {
                    1.$$$reportNull$$$0(1);
                }
                String string = fileNameWithoutExtension;
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            @NotNull
            public InspectionProfileImpl createScheme(@NotNull SchemeDataHolder<? super InspectionProfileImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                if (dataHolder == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (attributeProvider == null) {
                    1.$$$reportNull$$$0(5);
                }
                InspectionProfileImpl inspectionProfileImpl = new InspectionProfileImpl(name, InspectionToolRegistrar.getInstance(), ApplicationInspectionProfileManager.this, dataHolder);
                if (inspectionProfileImpl == null) {
                    1.$$$reportNull$$$0(6);
                }
                return inspectionProfileImpl;
            }

            @Override
            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(7);
                }
                ApplicationInspectionProfileManager.this.fireProfileChanged(scheme);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributeProvider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileNameWithoutExtension";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataHolder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSchemeKey";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getSchemeKey";
                        break;
                    }
                    case 2: 
                    case 6: {
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createScheme";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeAdded";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Override
    @NotNull
    protected SchemeManager<InspectionProfileImpl> getSchemeManager() {
        SchemeManager<InspectionProfileImpl> schemeManager2 = this.mySchemeManager;
        if (schemeManager2 == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(1);
        }
        return schemeManager2;
    }

    public static void registerProvidedSeverities() {
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            for (final HighlightInfoType t : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = t.getSeverity(null);
                SeverityRegistrar.registerStandard(t, highlightSeverity);
                TextAttributesKey attributesKey = t.getAttributesKey();
                IconLoader.LazyIcon icon = t instanceof HighlightInfoType.Iconable ? new IconLoader.LazyIcon(){

                    protected Icon compute() {
                        return ((HighlightInfoType.Iconable)((Object)t)).getIcon();
                    }
                } : null;
                HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (TextAttributesKey)attributesKey, (Icon)icon);
            }
        }
    }

    @Override
    @NotNull
    public Collection<InspectionProfileImpl> getProfiles() {
        this.initProfiles();
        List<InspectionProfileImpl> list2 = Collections.unmodifiableList(this.mySchemeManager.getAllSchemes());
        if (list2 == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.myProfilesAreInitialized.set(false);
    }

    public void initProfiles() {
        if (!this.myProfilesAreInitialized.compareAndSet(false, true) || !this.LOAD_PROFILES) {
            return;
        }
        this.loadBundledSchemes();
        this.mySchemeManager.loadSchemes();
        if (this.mySchemeManager.isEmpty()) {
            this.mySchemeManager.addScheme(new InspectionProfileImpl("Default", (Supplier<List<InspectionToolWrapper>>)InspectionToolRegistrar.getInstance(), this));
        }
    }

    private void loadBundledSchemes() {
        if (!ApplicationInspectionProfileManager.isUnitTestOrHeadlessMode()) {
            for (BundledSchemeEP ep : (BundledSchemeEP[])BUNDLED_EP_NAME.getExtensions()) {
                this.mySchemeManager.loadBundledScheme(ep.getPath() + ".xml", (Object)ep);
            }
        }
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public InspectionProfileImpl loadProfile(@NotNull String path) throws IOException, JDOMException {
        Path file2;
        if (path == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(3);
        }
        if (Files.isRegularFile(file2 = Paths.get(path, new String[0]), new LinkOption[0])) {
            try {
                return InspectionProfileLoadUtil.load(file2, InspectionToolRegistrar.getInstance(), this);
            }
            catch (IOException | JDOMException e) {
                throw e;
            }
            catch (Exception ignored) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, file2}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0])), ModalityState.NON_MODAL);
            }
        }
        return this.getProfile(path, false);
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.getSeverityRegistrar().writeExternal(state);
        return state;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(4);
        }
        this.getSeverityRegistrar().readExternal(state);
    }

    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    @Override
    public void setRootProfile(@Nullable String profileName) {
        this.mySchemeManager.setCurrentSchemeName(profileName);
    }

    @Override
    public InspectionProfileImpl getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        InspectionProfileImpl found;
        if (name == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(5);
        }
        if ((found = this.mySchemeManager.findSchemeByName(name)) != null) {
            return found;
        }
        if (returnRootProfileIfNamedIsAbsent) {
            return this.getCurrentProfile();
        }
        return null;
    }

    @Override
    @NotNull
    public InspectionProfileImpl getCurrentProfile() {
        this.initProfiles();
        InspectionProfileImpl current = this.mySchemeManager.getActiveScheme();
        if (current != null) {
            InspectionProfileImpl inspectionProfileImpl = current;
            if (inspectionProfileImpl == null) {
                ApplicationInspectionProfileManager.$$$reportNull$$$0(6);
            }
            return inspectionProfileImpl;
        }
        InspectionProfileImpl result2 = this.mySchemeManager.findSchemeByName("Default");
        if (result2 == null) {
            InspectionProfileImpl profile2 = new InspectionProfileImpl("Default");
            this.addProfile(profile2);
            InspectionProfileImpl inspectionProfileImpl = profile2;
            if (inspectionProfileImpl == null) {
                ApplicationInspectionProfileManager.$$$reportNull$$$0(7);
            }
            return inspectionProfileImpl;
        }
        InspectionProfileImpl inspectionProfileImpl = result2;
        if (inspectionProfileImpl == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(8);
        }
        return inspectionProfileImpl;
    }

    @NotNull
    public String getRootProfileName() {
        String string = (String)ObjectUtils.chooseNotNull((Object)this.mySchemeManager.getCurrentSchemeName(), (Object)"Default");
        if (string == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            ApplicationInspectionProfileManager.$$$reportNull$$$0(10);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectInspectionProfileManager.getInstance(project).fireProfileChanged(profile2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeManagerFactory";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/ApplicationInspectionProfileManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentProfile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProfileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadProfile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProfile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fireProfileChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

