/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.impl.LiveTemplateRunLogger;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.project.Project;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithLogger {
    private static final String USAGE_GROUP = "surround.with";

    public static void logSurrounder(Surrounder surrounder, @NotNull Language language, @NotNull Project project) {
        if (language == null) {
            SurroundWithLogger.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SurroundWithLogger.$$$reportNull$$$0(1);
        }
        SurroundWithLogger.log("surrounder", surrounder.getClass(), language, project);
    }

    private static void log(@NotNull String type, @NotNull Class elementClass, @NotNull Language language, @NotNull Project project) {
        if (type == null) {
            SurroundWithLogger.$$$reportNull$$$0(2);
        }
        if (elementClass == null) {
            SurroundWithLogger.$$$reportNull$$$0(3);
        }
        if (language == null) {
            SurroundWithLogger.$$$reportNull$$$0(4);
        }
        if (project == null) {
            SurroundWithLogger.$$$reportNull$$$0(5);
        }
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(elementClass);
        FeatureUsageData data = new FeatureUsageData().addPluginInfo(pluginInfo).addLanguage(language);
        data.addData("type", type);
        String description = pluginInfo.getType().isDevelopedByJetBrains() ? elementClass.getName() : "third.party";
        FUCounterUsageLogger.getInstance().logEvent(project, USAGE_GROUP, description, data);
    }

    static void logTemplate(@NotNull TemplateImpl template, @NotNull Language language, @NotNull Project project) {
        Triple<String, String, PluginInfo> keyGroupPluginToReport;
        if (template == null) {
            SurroundWithLogger.$$$reportNull$$$0(6);
        }
        if (language == null) {
            SurroundWithLogger.$$$reportNull$$$0(7);
        }
        if (project == null) {
            SurroundWithLogger.$$$reportNull$$$0(8);
        }
        if ((keyGroupPluginToReport = LiveTemplateRunLogger.getKeyGroupPluginToLog(template)) == null) {
            return;
        }
        FeatureUsageData data = new FeatureUsageData().addLanguage(language).addData("type", "template").addData("group", (String)keyGroupPluginToReport.getSecond());
        PluginInfo pluginInfo = (PluginInfo)keyGroupPluginToReport.getThird();
        if (pluginInfo != null) {
            data.addPluginInfo(pluginInfo);
        }
        FUCounterUsageLogger.getInstance().logEvent(project, USAGE_GROUP, (String)keyGroupPluginToReport.getFirst(), data);
    }

    static void logCustomTemplate(@NotNull CustomLiveTemplate template, @NotNull Language language, @NotNull Project project) {
        if (template == null) {
            SurroundWithLogger.$$$reportNull$$$0(9);
        }
        if (language == null) {
            SurroundWithLogger.$$$reportNull$$$0(10);
        }
        if (project == null) {
            SurroundWithLogger.$$$reportNull$$$0(11);
        }
        SurroundWithLogger.log("custom.template", template.getClass(), language, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/SurroundWithLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logSurrounder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logTemplate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "logCustomTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SurroundWithIdValidator
    extends CustomWhiteListRule {
        @Override
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "surround_with_id".equals(ruleId);
        }

        @Override
        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                SurroundWithIdValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SurroundWithIdValidator.$$$reportNull$$$0(1);
            }
            if ("third.party".equals(data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    SurroundWithIdValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            Object typeObject = context.eventData.get("type");
            if (!(typeObject instanceof String)) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    SurroundWithIdValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            if ("surrounder".equals(typeObject) || "custom.template".equals(typeObject)) {
                boolean isFromPluginRepository = PluginInfoDetectorKt.getPluginInfo(data).isSafeToReport();
                ValidationResultType validationResultType = isFromPluginRepository ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    SurroundWithIdValidator.$$$reportNull$$$0(4);
                }
                return validationResultType;
            }
            if ("template".equals(typeObject)) {
                Object group = context.eventData.get("group");
                ValidationResultType validationResultType = LiveTemplateRunLogger.LiveTemplateValidator.validateKeyGroup(data, group);
                if (validationResultType == null) {
                    SurroundWithIdValidator.$$$reportNull$$$0(5);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                SurroundWithIdValidator.$$$reportNull$$$0(6);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/impl/SurroundWithLogger$SurroundWithIdValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/impl/SurroundWithLogger$SurroundWithIdValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

