/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowContainerInfoHandler
implements CodeInsightActionHandler {
    private static final Key<WeakReference<LightweightHint>> MY_LAST_HINT_KEY = Key.create((String)"MY_LAST_HINT_KEY");
    private static final Key<PsiElement> CONTAINER_KEY = Key.create((String)"CONTAINER_KEY");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ShowContainerInfoHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowContainerInfoHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowContainerInfoHandler.$$$reportNull$$$0(2);
        }
        PsiElement container = ShowContainerInfoHandler.getProcessedHint(editor);
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(file2);
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            StructureViewModel model2 = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(editor);
            boolean goOneLevelUp = true;
            try {
                if (container == null) {
                    goOneLevelUp = false;
                    Object element = model2.getCurrentEditorElement();
                    if (element instanceof PsiElement) {
                        container = (PsiElement)element;
                    }
                }
            }
            finally {
                Disposer.dispose((Disposable)model2);
            }
            while (true) {
                if (container != null && DeclarationRangeUtil.getPossibleDeclarationAtRange(container) == null) {
                    if (!((container = container.getParent()) instanceof PsiFile)) continue;
                    return;
                }
                if (container == null || container instanceof PsiFile) {
                    return;
                }
                if (goOneLevelUp) {
                    goOneLevelUp = false;
                } else if (!ShowContainerInfoHandler.isDeclarationVisible(container, editor)) break;
                container = container.getParent();
            }
        }
        if (container == null) {
            return;
        }
        TextRange range2 = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        if (range2 == null) {
            return;
        }
        PsiElement _container = container;
        ApplicationManager.getApplication().invokeLater(() -> {
            LightweightHint hint1 = EditorFragmentComponent.showEditorFragmentHint(editor, range2, true, true);
            if (hint1 != null) {
                hint1.putUserData(CONTAINER_KEY, _container);
                editor.putUserData(MY_LAST_HINT_KEY, new WeakReference<LightweightHint>(hint1));
            }
        });
    }

    @Nullable
    public static PsiElement getProcessedHint(@NotNull Editor editor) {
        WeakReference ref;
        LightweightHint hint;
        if (editor == null) {
            ShowContainerInfoHandler.$$$reportNull$$$0(3);
        }
        if ((hint = (LightweightHint)SoftReference.dereference((Reference)(ref = (WeakReference)editor.getUserData(MY_LAST_HINT_KEY)))) != null && hint.isVisible()) {
            hint.hide();
            PsiElement container = (PsiElement)hint.getUserData(CONTAINER_KEY);
            if (container != null && container.isValid()) {
                return container;
            }
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static boolean isDeclarationVisible(PsiElement container, Editor editor) {
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        TextRange range2 = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        if (range2 == null) {
            return false;
        }
        LogicalPosition pos = editor.offsetToLogicalPosition(range2.getStartOffset());
        Point loc = editor.logicalPositionToXY(pos);
        return loc.y >= viewRect.y;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hint/ShowContainerInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessedHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

