/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramActionsManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramAction
extends AnAction
implements Toggleable {
    private static final Logger LOG = Logger.getInstance(DiagramAction.class);

    public DiagramAction() {
        this.setEnabledInModalContext(true);
    }

    protected DiagramAction(String name, @Nullable String description, @Nullable Icon icon) {
        super(name, description, icon);
        this.setEnabledInModalContext(true);
    }

    public boolean isDumbAware() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(0);
        }
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        e.getPresentation().setEnabled(builder != null && this.isEnabled(e, builder));
        if (builder != null) {
            e.getPresentation().putClientProperty("selected", (Object)this.isSelected(e, builder));
        }
    }

    public abstract void perform(@NotNull AnActionEvent var1);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(1);
        }
        if ((builder = DiagramAction.getBuilder(e)) != null) {
            Project project = builder.getProject();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            DiagramState oldState = new DiagramState(builder);
            if (this instanceof DiagramActionWithPreparation) {
                DiagramActionWithPreparation actionWithPreparation = (DiagramActionWithPreparation)this;
                Object data = ReadAction.compute(() -> actionWithPreparation.prepare(e));
                if (data != null) {
                    WriteCommandAction.writeCommandAction((Project)project).withName(this.getActionName()).withGroupId(this.getActionGroupId(e)).run(() -> {
                        PsiFile[] files = this.getAffectedFiles(e);
                        actionWithPreparation.execute(builder, data, e);
                        DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
                        builder.notifyOtherBuilders();
                    });
                }
            } else if (this.isUndoable(e)) {
                WriteCommandAction.writeCommandAction((Project)project).withName(this.getActionName()).withGroupId(this.getActionGroupId(e)).run(() -> {
                    PsiFile[] files = this.getAffectedFiles(e);
                    this.perform(e);
                    DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
                    builder.notifyOtherBuilders();
                });
            } else {
                this.perform(e);
                builder.notifyOtherBuilders();
            }
        }
    }

    public PsiFile[] getAffectedFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(2);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    @Nullable
    public static DiagramBuilder getBuilder(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(3);
        }
        return DiagramAction.getBuilderFromActionEvent(e);
    }

    @Nullable
    public static DiagramProvider getProvider(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(4);
        }
        return (builder = DiagramAction.getBuilder(e)) == null ? null : builder.getProvider();
    }

    @Nullable
    public static DiagramDataModel getDataModel(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(5);
        }
        return (builder = DiagramAction.getBuilder(e)) == null ? null : builder.getDataModel();
    }

    @Nullable
    public static DiagramBuilder getBuilderFromActionEvent(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(6);
        }
        return (DiagramBuilder)e.getData(DiagramDataKeys.BUILDER);
    }

    @Nullable
    public static Graph2D getGraph(AnActionEvent e) {
        DiagramBuilder builder = DiagramAction.getBuilder(e);
        return builder == null ? null : builder.getGraph();
    }

    public boolean isSelected(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(7);
        }
        return false;
    }

    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(8);
        }
        return true;
    }

    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(9);
        }
        return true;
    }

    @Nullable
    public String getActionGroupId(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(10);
        }
        return null;
    }

    public abstract String getActionName();

    public static List<DiagramNode> getSelectedNodes(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(11);
        }
        return DiagramAction.getSelectedNodes(DiagramAction.getBuilder(e));
    }

    public static List<DiagramNode> getSelectedNodes(DiagramBuilder builder) {
        ArrayList<DiagramNode> selected = new ArrayList<DiagramNode>();
        if (builder != null) {
            for (DiagramNode umlNode : builder.getNodeObjects()) {
                Node node = builder.getNode(umlNode);
                if (node == null || !builder.getGraph().isSelected(node)) continue;
                selected.add(umlNode);
            }
        }
        return selected;
    }

    public static List<DiagramNode> getSelectedNodesExceptNotes(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramAction.$$$reportNull$$$0(12);
        }
        return (builder = DiagramAction.getBuilder(e)) == null ? Collections.emptyList() : Utils.getSelectedNodesExceptNotes(builder);
    }

    public static Runnable createCallback(DiagramBuilder builder, @NotNull PopupCallback callback) {
        if (callback == null) {
            DiagramAction.$$$reportNull$$$0(13);
        }
        return () -> {
            DiagramState oldState = new DiagramState(builder);
            Project project = builder.getProject();
            WriteCommandAction.writeCommandAction((Project)project).withName(callback.getActionName()).withGroupId(callback.getGroupName()).run(() -> {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                PsiFile[] files = callback.getAffectedFiles();
                callback.run();
                DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
            });
        };
    }

    public static <T> T performCommand(DiagramBuilder builder, Callable<T> call, String commandName, @Nullable String groupName, PsiElement ... elements) {
        PsiFile[] files = DiagramAction.getPsiFiles(elements);
        Project project = builder.getProject();
        CommandProcessor processor = CommandProcessor.getInstance();
        if (processor.getCurrentCommand() != null) {
            processor.setCurrentCommandName(commandName);
            processor.setCurrentCommandGroupId((Object)groupName);
        }
        try {
            return (T)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])files).withName(commandName).withGroupId(groupName).compute(() -> {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                DiagramState oldState = new DiagramState(builder);
                Object t = call.call();
                DiagramActionsManager.getInstance(project).notifyUmlListeners(builder, oldState, files);
                builder.notifyOtherBuilders();
                return t;
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiFile[] getPsiFiles(PsiElement[] elements) {
        if (elements.length == 0) {
            return PsiFile.EMPTY_ARRAY;
        }
        HashSet<PsiFile> files = new HashSet<PsiFile>();
        for (PsiElement element : elements) {
            if (element instanceof PsiFile) {
                files.add((PsiFile)element);
                continue;
            }
            PsiFile file = element.getContainingFile();
            if (file == null) continue;
            files.add(file);
        }
        return files.toArray(PsiFile.EMPTY_ARRAY);
    }

    public static void performCommand(DiagramBuilder builder, Runnable run, String commandName, @Nullable String groupName, PsiElement ... elements) {
        Callable<Object> call = () -> {
            run.run();
            return null;
        };
        DiagramAction.performCommand(builder, call, commandName, groupName, elements);
    }

    public static void showNotification(String message, DiagramBuilder builder) {
        DiagramAction.showNotification(message, new RelativePoint(Utils.getGraphCenterOnScreen(builder.getGraph())));
    }

    public static void showNotification(String message, DiagramNode<?> node, DiagramBuilder builder) {
        Point point = Utils.getNodeCoordinatesOnScreen(builder.getNode(node), builder.getView());
        DiagramAction.showNotification(message, new RelativePoint(point));
    }

    public static void showNotification(String message, RelativePoint point) {
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.INFO, null).setFadeoutTime(2000L).setHideOnClickOutside(true).setHideOnKeyOutside(true).createBalloon().show(point, Balloon.Position.above);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagram/DiagramAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuilderFromActionEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionGroupId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedNodes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedNodesExceptNotes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

