/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class UpdateData<Key, Value> {
    private final Map<Key, Value> myNewData;
    private final ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> myCurrentDataEvaluator;
    private final IndexId<Key, Value> myIndexId;
    private final ThrowableRunnable<? extends IOException> myForwardIndexUpdate;

    public UpdateData(@NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> currentDataEvaluator, @NotNull IndexId<Key, Value> indexId, @Nullable ThrowableRunnable<? extends IOException> forwardIndexUpdate) {
        if (newData == null) {
            UpdateData.$$$reportNull$$$0(0);
        }
        if (currentDataEvaluator == null) {
            UpdateData.$$$reportNull$$$0(1);
        }
        if (indexId == null) {
            UpdateData.$$$reportNull$$$0(2);
        }
        this.myNewData = newData;
        this.myCurrentDataEvaluator = currentDataEvaluator;
        this.myIndexId = indexId;
        this.myForwardIndexUpdate = forwardIndexUpdate;
    }

    boolean iterateKeys(@NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        InputDataDiffBuilder<? super Key, ? super Value> currentData;
        if (addProcessor == null) {
            UpdateData.$$$reportNull$$$0(3);
        }
        if (updateProcessor == null) {
            UpdateData.$$$reportNull$$$0(4);
        }
        if (removeProcessor == null) {
            UpdateData.$$$reportNull$$$0(5);
        }
        try {
            currentData = this.getCurrentDataEvaluator().compute();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        return currentData.differentiate(this.myNewData, addProcessor, updateProcessor, removeProcessor);
    }

    @NotNull
    protected ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> getCurrentDataEvaluator() {
        ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> throwableComputable = this.myCurrentDataEvaluator;
        if (throwableComputable == null) {
            UpdateData.$$$reportNull$$$0(6);
        }
        return throwableComputable;
    }

    @NotNull
    public Map<Key, Value> getNewData() {
        Map<Key, Value> map = this.myNewData;
        if (map == null) {
            UpdateData.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public IndexId<Key, Value> getIndexId() {
        IndexId<Key, Value> indexId = this.myIndexId;
        if (indexId == null) {
            UpdateData.$$$reportNull$$$0(8);
        }
        return indexId;
    }

    void updateForwardIndex() throws IOException {
        if (this.myForwardIndexUpdate != null) {
            this.myForwardIndexUpdate.run();
        }
    }

    public String toString() {
        return this.myIndexId + "," + this.getClass().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDataEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/UpdateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/UpdateData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDataEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateKeys";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

