/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PropertiesUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jpountz.lz4.LZ4Factory;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.intellij.lang.annotations.Flow;
import org.jdom.Document;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    public static final String DEFAULT_OPTIONS_FILE = "other.xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String LIB_FOLDER = "lib";
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String BIN_FOLDER = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_FOLDER = "config";
    private static final String SYSTEM_FOLDER = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static String ourHomePath;
    private static String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        String string = PathManager.getHomePath(true);
        if (string == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        String fromProperty = System.getProperty(PROPERTY_HOME_PATH, System.getProperty(PROPERTY_HOME));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else if (insideIde && (ourHomePath = PathManager.getHomePathFor(PathManager.class)) == null) {
            String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
            throw new RuntimeException("Could not find installation home path. Please " + advice);
        }
        if (ourHomePath != null && SystemInfo.isWindows) {
            ourHomePath = PathManager.canonicalPath(ourHomePath);
        }
        ourBinDirectories = ourHomePath != null ? PathManager.getBinDirectories(new File(ourHomePath)) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        return ourHomePath;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        return FileUtil.isAncestor(PathManager.canonicalPath(PathManager.getHomePath()), PathManager.canonicalPath(path), true);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass) {
        String rootPath;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        File root = new File(rootPath).getAbsoluteFile();
        while ((root = root.getParentFile()) != null && !PathManager.isIdeaHome(root)) {
        }
        return root != null ? root.getPath() : null;
    }

    private static boolean isIdeaHome(@NotNull File root) {
        if (root == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        for (String binDir : PathManager.getBinDirectories(root)) {
            if (!new File(binDir, PROPERTIES_FILE_NAME).isFile()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String[] getBinDirectories(@NotNull File root) {
        if (root == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        SmartList<String> binDirs = new SmartList<String>();
        String[] subDirs = new String[]{BIN_FOLDER, "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(binDirs);
        if (stringArray == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + "/" + BIN_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        PathManager.getHomePath();
        for (String binDir : ourBinDirectories) {
            File file = new File(binDir, fileName);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        if ((file = PathManager.findBinFile(fileName)) != null) {
            File file2 = file;
            if (file2 == null) {
                PathManager.$$$reportNull$$$0(9);
            }
            return file2;
        }
        String paths = StringUtil.join(ourBinDirectories, "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getLibPath() {
        String string = PathManager.getHomePath() + "/" + LIB_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + "/" + PLUGINS_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(12);
            }
            return string;
        }
        String fromProp = System.getProperty(PROPERTY_CONFIG_PATH);
        ourConfigPath = fromProp != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(fromProp)) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + "/" + CONFIG_FOLDER);
        String string = ourConfigPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            String string = ourScratchPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(14);
            }
            return string;
        }
        String fromProp = System.getProperty(PROPERTY_SCRATCH_PATH);
        ourScratchPath = fromProp != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(fromProp)) : PathManager.getConfigPath();
        String string = ourScratchPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", CONFIG_FOLDER);
        if (string == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void ensureConfigFolderExists() {
        FileUtilRt.createDirectory(new File(PathManager.getConfigPath()));
    }

    @NotNull
    public static String getOptionsPath() {
        String string = PathManager.getConfigPath() + "/" + OPTIONS_DIRECTORY;
        if (string == null) {
            PathManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        File file = new File(PathManager.getOptionsPath(), fileName + DEFAULT_EXT);
        if (file == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        return file;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(21);
            }
            return string;
        }
        ourPluginsPath = System.getProperty(PROPERTY_PLUGINS_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_PLUGINS_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Application Support", "") : PathManager.getConfigPath() + "/" + PLUGINS_FOLDER);
        String string = ourPluginsPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(23);
        }
        if (SystemInfo.isMac) {
            String string = PathManager.platformPath(selector, "Library/Application Support", "");
            if (string == null) {
                PathManager.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = PathManager.getDefaultConfigPathFor(selector) + "/" + PLUGINS_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(26);
            }
            return string;
        }
        ourSystemPath = System.getProperty(PROPERTY_SYSTEM_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SYSTEM_PATH))) : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + "/" + SYSTEM_FOLDER);
        FileUtilRt.createDirectory(new File(ourSystemPath));
        String string = ourSystemPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        String string = PathManager.platformPath(selector, "Library/Caches", SYSTEM_FOLDER);
        if (string == null) {
            PathManager.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static String getTempPath() {
        String string = PathManager.getSystemPath() + "/tmp";
        if (string == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtilRt.createDirectory(indexRoot);
        File file = indexRoot;
        if (file == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        return file;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            String string = ourLogPath;
            if (string == null) {
                PathManager.$$$reportNull$$$0(32);
            }
            return string;
        }
        ourLogPath = System.getProperty(PROPERTY_LOG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_LOG_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + "/Library/Logs/" + PATHS_SELECTOR : PathManager.getSystemPath() + "/" + LOG_DIRECTORY);
        String string = ourLogPath;
        if (string == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String getPluginTempPath() {
        String string = PathManager.getSystemPath() + "/" + PLUGINS_FOLDER;
        if (string == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, @NotNull String path) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        if ((url = context.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, @NotNull String resourcePath) {
        URL url;
        if (cl == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        return (url = cl.getResource(resourcePath)) != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(@NotNull URL resourceURL, @NotNull String resourcePath) {
        if (resourceURL == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(40);
        }
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = FileUtilRt.toSystemDependentName((String)paths.first);
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return StringUtil.trimEnd(resultPath, "/");
    }

    public static void loadProperties() {
        PathManager.getHomePath();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(SystemProperties.getUserHome() + '/' + PROPERTIES_FILE_NAME);
        for (String binDir : ourBinDirectories) {
            paths.add(binDir + '/' + PROPERTIES_FILE_NAME);
        }
        Properties sysProperties = System.getProperties();
        for (String path : paths) {
            if (path == null || !new File(path).exists()) continue;
            try {
                FileReader reader = new FileReader(path);
                Throwable throwable = null;
                try {
                    Map<String, String> properties = PropertiesUtil.loadProperties(reader);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key = entry.getKey();
                        if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                            PathManager.log(path + ": '" + key + "' cannot be redefined");
                            continue;
                        }
                        if (sysProperties.containsKey(key)) continue;
                        sysProperties.setProperty(key, PathManager.substituteVars(entry.getValue()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + "/" + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, @NotNull String ideaHomePath) {
        if (ideaHomePath == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + "/" + BIN_FOLDER + "/" + s;
        }
        Matcher m = Lazy.PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                    value = ideaHomePath;
                } else if (PROPERTY_CONFIG_PATH.equals(key)) {
                    value = PathManager.getConfigPath();
                } else if (PROPERTY_SYSTEM_PATH.equals(key)) {
                    value = PathManager.getSystemPath();
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = StringUtil.replace(s, m.group(), value);
            m = Lazy.PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        File file;
        if (relativePath == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        File file2 = (file = new File(PathManager.getLibPath() + "/" + relativePath)).exists() ? file : new File(PathManager.getHomePath(), "community/lib/" + relativePath);
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(43);
        }
        return file2;
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path = PathManager.getHomePath();
        if (new File(path, "community/.idea").isDirectory()) {
            String string = path + "/community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(44);
            }
            return string;
        }
        if (new File(path, "ultimate/community/.idea").isDirectory()) {
            String string = path + "/ultimate/community";
            if (string == null) {
                PathManager.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class")) != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        Class[] classes = new Class[]{PathManager.class, Flow.class, SystemInfoRt.class, UrlClassLoader.class, Document.class, Appender.class, THashSet.class, TypeMapper.class, FileUtils.class, PatternMatcher.class, LZ4Factory.class};
        HashSet<String> classPath = new HashSet<String>();
        for (Class aClass : classes) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        String resourceRoot = PathManager.getResourceRoot(PathManager.class, "/messages/CommonBundle.properties");
        if (resourceRoot != null) {
            classPath.add(new File(resourceRoot).getAbsolutePath());
        }
        Collection<String> collection = Collections.unmodifiableCollection(classPath);
        if (collection == null) {
            PathManager.$$$reportNull$$$0(48);
        }
        return collection;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(49);
        }
        path = FileUtil.expandUserHome(path);
        String string = FileUtil.toCanonicalPath(new File(path).getAbsolutePath());
        if (string == null) {
            PathManager.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    public static String trimPathQuotes(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(51);
        }
        if (path.length() >= 3 && StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            path = path.substring(1, path.length() - 1);
        }
        String string = path;
        if (string == null) {
            PathManager.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(53);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        String string = PathManager.platformPath(selector, macPart, null, null, null, fallback);
        if (string == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        if (fallback == null) {
            PathManager.$$$reportNull$$$0(57);
        }
        String userHome = SystemProperties.getUserHome();
        if (macPart != null && SystemInfo.isMac) {
            String string = userHome + "/" + macPart + "/" + selector;
            if (string == null) {
                PathManager.$$$reportNull$$$0(58);
            }
            return string;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            String string = dir + "/" + selector;
            if (string == null) {
                PathManager.$$$reportNull$$$0(59);
            }
            return string;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = userHome + "/" + xdgDir;
            }
            String string = dir + "/" + selector;
            if (string == null) {
                PathManager.$$$reportNull$$$0(60);
            }
            return string;
        }
        String string = userHome + "/." + selector + (!fallback.isEmpty() ? "/" + fallback : "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(61);
        }
        return string;
    }

    @NotNull
    private static String canonicalPath(@NotNull String path) {
        String string;
        if (path == null) {
            PathManager.$$$reportNull$$$0(62);
        }
        try {
            string = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            String string2 = path;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(64);
            }
            return string2;
        }
        if (string == null) {
            PathManager.$$$reportNull$$$0(63);
        }
        return string;
    }

    @Nullable
    public static File getLogFile() {
        String logXmlPath = System.getProperty(PROPERTY_LOG_CONFIG_FILE);
        if (logXmlPath == null) {
            return null;
        }
        File logXmlFile = logXmlPath.indexOf(47) < 0 && logXmlPath.indexOf(92) < 0 ? new File(PathManager.getBinPath(), logXmlPath) : new File(logXmlPath);
        if (logXmlFile.exists()) {
            return logXmlFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 36: 
            case 49: 
            case 51: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: 
            case 23: 
            case 28: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceURL";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "trimPathQuotes";
                break;
            }
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "platformPath";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIdeaHome";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBinDirectories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "extractRoot";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "trimPathQuotes";
                break;
            }
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "platformPath";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "canonicalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 23: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 62: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

