/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;

public class WinProcessManager {
    private static final Logger LOG = Logger.getInstance(WinProcessManager.class);

    private WinProcessManager() {
    }

    public static int getProcessId(Process process) {
        String processClassName = process.getClass().getName();
        if (processClassName.equals("java.lang.Win32Process") || processClassName.equals("java.lang.ProcessImpl")) {
            try {
                if (SystemInfo.IS_AT_LEAST_JAVA9) {
                    return ((Long)Process.class.getMethod("pid", new Class[0]).invoke((Object)process, new Object[0])).intValue();
                }
                long handle = ObjectUtils.assertNotNull(ReflectionUtil.getField(process.getClass(), process, Long.TYPE, "handle"));
                return Kernel32.INSTANCE.GetProcessId(new WinNT.HANDLE(Pointer.createConstant((long)handle)));
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to get PID from instance of " + process.getClass() + ", OS: " + SystemInfo.OS_NAME, t);
            }
        }
        throw new IllegalStateException("Unable to get PID from instance of " + process.getClass() + ", OS: " + SystemInfo.OS_NAME);
    }

    public static int getCurrentProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    public static boolean kill(Process process, boolean tree) {
        return WinProcessManager.kill(-1, process, tree);
    }

    public static boolean kill(int pid, boolean tree) {
        return WinProcessManager.kill(pid, null, tree);
    }

    private static boolean kill(int pid, Process process, boolean tree) {
        LOG.assertTrue(pid > 0 || process != null);
        try {
            if (process != null) {
                pid = WinProcessManager.getProcessId(process);
            }
            String[] cmdArray = new String[]{"taskkill", "/f", "/pid", String.valueOf(pid), tree ? "/t" : ""};
            if (LOG.isDebugEnabled()) {
                LOG.debug(StringUtil.join(cmdArray, " "));
            }
            Process p = new ProcessBuilder(cmdArray).redirectErrorStream(true).start();
            String output = FileUtil.loadTextAndClose(p.getInputStream());
            int res = p.waitFor();
            if (res != 0 && (process == null || WinProcessManager.isAlive(process))) {
                LOG.warn(StringUtil.join(cmdArray, " ") + " failed: " + output);
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(output);
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    private static boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }
}

