/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.util.containers.ObjectLongHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartUpMeasurer {
    public static boolean measuringPluginStartupCosts = true;
    private static final long classInitStartTime = System.nanoTime();
    private static final ConcurrentLinkedQueue<ActivityImpl> items = new ConcurrentLinkedQueue();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, ObjectLongHashMap<String>> pluginCostMap = new HashMap<String, ObjectLongHashMap<String>>();

    public static void stopPluginCostMeasurement() {
        measuringPluginStartupCosts = false;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static long getCurrentTime() {
        return System.nanoTime();
    }

    @NotNull
    public static Activity start(@NotNull String name, @Nullable String description) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(0);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, description, null, null);
        if (activityImpl == null) {
            StartUpMeasurer.$$$reportNull$$$0(1);
        }
        return activityImpl;
    }

    @NotNull
    public static Activity start(@NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(2);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, null, null, null);
        if (activityImpl == null) {
            StartUpMeasurer.$$$reportNull$$$0(3);
        }
        return activityImpl;
    }

    @NotNull
    public static Activity start(@NotNull String name, @NotNull Level level) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(4);
        }
        if (level == null) {
            StartUpMeasurer.$$$reportNull$$$0(5);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, null, level, null);
        if (activityImpl == null) {
            StartUpMeasurer.$$$reportNull$$$0(6);
        }
        return activityImpl;
    }

    public static void processAndClear(boolean isContinueToCollect, @NotNull Consumer<? super ActivityImpl> consumer) {
        ActivityImpl item;
        if (consumer == null) {
            StartUpMeasurer.$$$reportNull$$$0(7);
        }
        isEnabled = isContinueToCollect;
        while ((item = items.poll()) != null) {
            consumer.accept(item);
        }
    }

    @ApiStatus.Internal
    public static long getClassInitStartTime() {
        return classInitStartTime;
    }

    static void add(@NotNull ActivityImpl activity) {
        if (activity == null) {
            StartUpMeasurer.$$$reportNull$$$0(8);
        }
        if (isEnabled) {
            items.add(activity);
        }
    }

    public static void addTimings(@NotNull LinkedHashMap<String, Long> timings, @NotNull String groupName) {
        if (timings == null) {
            StartUpMeasurer.$$$reportNull$$$0(9);
        }
        if (groupName == null) {
            StartUpMeasurer.$$$reportNull$$$0(10);
        }
        if (timings.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, Long>> entries = new ArrayList<Map.Entry<String, Long>>(timings.entrySet());
        ActivityImpl parent = new ActivityImpl(groupName, null, (Long)((Map.Entry)entries.get(0)).getValue(), null, Level.APPLICATION, null, null);
        parent.setEnd(StartUpMeasurer.getCurrentTime());
        for (int i = 0; i < entries.size(); ++i) {
            ActivityImpl activity = new ActivityImpl((String)((Map.Entry)entries.get(i)).getKey(), null, (Long)((Map.Entry)entries.get(i)).getValue(), parent, Level.APPLICATION, null, null);
            activity.setEnd(i == entries.size() - 1 ? parent.getEnd() : ((Long)((Map.Entry)entries.get(i + 1)).getValue()).longValue());
            items.add(activity);
        }
        items.add(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPluginCost(@Nullable String pluginId, @NotNull String phase, long timeNanos) {
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(11);
        }
        if (pluginId == null || !measuringPluginStartupCosts) {
            return;
        }
        Map<String, ObjectLongHashMap<String>> map = pluginCostMap;
        synchronized (map) {
            StartUpMeasurer.doAddPluginCost(pluginId, phase, timeNanos, pluginCostMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static void doAddPluginCost(@NotNull String pluginId, @NotNull String phase, long timeNanos, @NotNull Map<String, ObjectLongHashMap<String>> map) {
        long oldCost;
        void pluginCostMap;
        ObjectLongHashMap<String> costPerPhaseMap;
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(12);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(13);
        }
        if (map == null) {
            StartUpMeasurer.$$$reportNull$$$0(14);
        }
        if ((costPerPhaseMap = (ObjectLongHashMap<String>)((Object)pluginCostMap.get(pluginId))) == null) {
            costPerPhaseMap = new ObjectLongHashMap<String>();
            pluginCostMap.put(pluginId, costPerPhaseMap);
        }
        if ((oldCost = costPerPhaseMap.get(phase)) == -1L) {
            oldCost = 0L;
        }
        costPerPhaseMap.put(phase, oldCost + timeNanos);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/StartUpMeasurer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginCostMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/StartUpMeasurer";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAndClear";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTimings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPluginCost";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doAddPluginCost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Level {
        APPLICATION("app"),
        PROJECT("project"),
        MODULE("module");

        private final String jsonFieldNamePrefix;

        private Level(String jsonFieldNamePrefix) {
            if (jsonFieldNamePrefix == null) {
                Level.$$$reportNull$$$0(0);
            }
            this.jsonFieldNamePrefix = jsonFieldNamePrefix;
        }

        @NotNull
        public String getJsonFieldNamePrefix() {
            String string = this.jsonFieldNamePrefix;
            if (string == null) {
                Level.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonFieldNamePrefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/StartUpMeasurer$Level";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/StartUpMeasurer$Level";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJsonFieldNamePrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Phases {
        public static final String LOAD_MAIN_CLASS = "load main class";
        public static final String PREPARE_TO_INIT_APP = "app initialization preparation";
        public static final String CHECK_SYSTEM_DIR = "check system dirs";
        public static final String LOCK_SYSTEM_DIRS = "lock system dirs";
        public static final String START_LOGGING = "start logging";
        public static final String WAIT_TASKS = "wait tasks";
        public static final String CONFIGURE_LOGGING = "configure logging";
        public static final String INIT_APP = "app initialization";
        public static final String PLACE_ON_EVENT_QUEUE = "place on event queue";
        public static final String WAIT_PLUGIN_INIT = "wait plugin initialization";
        public static final String REGISTER_COMPONENTS_SUFFIX = "component registration";
        public static final String COMPONENTS_REGISTERED_CALLBACK_SUFFIX = "component registered callback";
        public static final String CREATE_COMPONENTS_SUFFIX = "component creation";
        public static final String APP_INITIALIZED_CALLBACK = "app initialized callback";
        public static final String FRAME_INITIALIZATION = "frame initialization";
        public static final String PROJECT_CONVERSION = "project conversion";
        public static final String PROJECT_BEFORE_LOADED = "project before loaded callbacks";
        public static final String PROJECT_INSTANTIATION = "project instantiation";
        public static final String PROJECT_PRE_STARTUP = "project pre-startup";
        public static final String PROJECT_STARTUP = "project startup";
        public static final String PROJECT_DUMB_POST_STARTUP = "project dumb post-startup";
        public static final String RUN_PROJECT_POST_STARTUP_ACTIVITIES_DUMB_AWARE = "project post-startup dumb-aware activities";
        public static final String RUN_PROJECT_POST_STARTUP_ACTIVITIES_EDT = "project post-startup edt activities";
        public static final String LOAD_MODULES = "module loading";
        public static final String PROJECT_OPENED_CALLBACKS = "project opened callbacks";
        public static final String RESTORING_EDITORS = "restoring editors";
    }
}

