/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class CommonBundle
extends BundleBase {
    private static final String BUNDLE = "messages.CommonBundle";
    private static Reference<ResourceBundle> ourBundle;

    private CommonBundle() {
    }

    @Nls
    @NotNull
    public static String message(@NotNull @PropertyKey(resourceBundle="messages.CommonBundle") String key, Object ... params) {
        if (key == null) {
            CommonBundle.$$$reportNull$$$0(0);
        }
        if (params == null) {
            CommonBundle.$$$reportNull$$$0(1);
        }
        String string = CommonBundle.message(CommonBundle.getCommonBundle(), key, params);
        if (string == null) {
            CommonBundle.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static ResourceBundle getCommonBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            CommonBundle.$$$reportNull$$$0(3);
        }
        return resourceBundle;
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        if (key == null) {
            CommonBundle.$$$reportNull$$$0(4);
        }
        if (params == null) {
            CommonBundle.$$$reportNull$$$0(5);
        }
        if (bundle == null) {
            return defaultValue;
        }
        if (!bundle.containsKey(key)) {
            return CommonBundle.postprocessValue(bundle, CommonBundle.useDefaultValue(bundle, key, defaultValue), params);
        }
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params);
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            CommonBundle.$$$reportNull$$$0(6);
        }
        if (key == null) {
            CommonBundle.$$$reportNull$$$0(7);
        }
        if (params == null) {
            CommonBundle.$$$reportNull$$$0(8);
        }
        String string = BundleBase.message(bundle, key, params);
        if (string == null) {
            CommonBundle.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static String messageOfNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        String value;
        if (bundle == null) {
            CommonBundle.$$$reportNull$$$0(10);
        }
        if (key == null) {
            CommonBundle.$$$reportNull$$$0(11);
        }
        if (params == null) {
            CommonBundle.$$$reportNull$$$0(12);
        }
        if (key.equals(value = CommonBundle.messageOrDefault(bundle, key, key, params))) {
            return null;
        }
        return value;
    }

    @NotNull
    public static String getCancelButtonText() {
        String string = CommonBundle.message("button.cancel", new Object[0]);
        if (string == null) {
            CommonBundle.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static String getBackgroundButtonText() {
        return CommonBundle.message("button.background", new Object[0]);
    }

    public static String getHelpButtonText() {
        return CommonBundle.message("button.help", new Object[0]);
    }

    public static String getErrorTitle() {
        return CommonBundle.message("title.error", new Object[0]);
    }

    @Deprecated
    public static String getWarningTitle() {
        return CommonBundle.message("title.warning", new Object[0]);
    }

    public static String getLoadingTreeNodeText() {
        return CommonBundle.message("tree.node.loading", new Object[0]);
    }

    public static String getOkButtonText() {
        return CommonBundle.message("button.ok", new Object[0]);
    }

    public static String getYesButtonText() {
        return CommonBundle.message("button.yes", new Object[0]);
    }

    public static String getNoButtonText() {
        return CommonBundle.message("button.no", new Object[0]);
    }

    public static String getContinueButtonText() {
        return CommonBundle.message("button.continue", new Object[0]);
    }

    public static String getYesForAllButtonText() {
        return CommonBundle.message("button.yes.for.all", new Object[0]);
    }

    public static String getCloseButtonText() {
        return CommonBundle.message("button.close", new Object[0]);
    }

    public static String getNoForAllButtonText() {
        return CommonBundle.message("button.no.for.all", new Object[0]);
    }

    public static String getApplyButtonText() {
        return CommonBundle.message("button.apply", new Object[0]);
    }

    public static String getAddButtonText() {
        return CommonBundle.message("button.add.a", new Object[0]);
    }

    public static String settingsTitle() {
        return SystemInfo.isMac ? CommonBundle.message("title.settings.mac", new Object[0]) : CommonBundle.message("title.settings", new Object[0]);
    }

    public static String settingsAction() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.mac", new Object[0]) : CommonBundle.message("action.settings", new Object[0]);
    }

    public static String settingsActionDescription() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.description.mac", new Object[0]) : CommonBundle.message("action.settings.description", new Object[0]);
    }

    public static String settingsActionPath() {
        return SystemInfo.isMac ? CommonBundle.message("action.settings.path.mac", new Object[0]) : CommonBundle.message("action.settings.path", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/CommonBundle";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/CommonBundle";
                break;
            }
            case 2: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonBundle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelButtonText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "messageOfNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

