/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.profiler.ProfilerCommunication;
import com.jetbrains.python.profiler.ProfilerCommunicationKt;
import com.jetbrains.python.profiler.ProfilerCommunicationKt$sam$com_google_common_base_Function$0;
import com.jetbrains.python.profiler.ProfilerRequest;
import com.jetbrains.python.profiler.ProfilerResponse;
import com.jetbrains.python.profiler.SaveSnapshot_Req;
import com.jetbrains.python.profiler.Stats;
import com.jetbrains.python.profiler.Stats_Req;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130$J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0$J0\u0010'\u001a\b\u0012\u0004\u0012\u0002H(0$\"\u0004\b\u0000\u0010(2\u0006\u0010)\u001a\u00020*2\u0014\u0010+\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u0002H(0,J\u000e\u0010-\u001a\u00020\"2\u0006\u0010)\u001a\u00020*R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR9\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010j\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lcom/jetbrains/python/profiler/ProfilerCommunication;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "serverSocket", "Ljava/net/ServerSocket;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/net/ServerSocket;Lcom/intellij/execution/process/ProcessHandler;)V", "getProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "getProject", "()Lcom/intellij/openapi/project/Project;", "responses", "Ljava/util/HashMap;", "", "Lcom/google/common/util/concurrent/SettableFuture;", "Lcom/jetbrains/python/profiler/ProfilerResponse;", "Lkotlin/collections/HashMap;", "getResponses", "()Ljava/util/HashMap;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getServerSocket", "()Ljava/net/ServerSocket;", "writer", "Ljava/io/DataOutputStream;", "getWriter", "()Ljava/io/DataOutputStream;", "setWriter", "(Ljava/io/DataOutputStream;)V", "acceptConnection", "", "captureSnapshot", "Lcom/google/common/util/concurrent/ListenableFuture;", "requestStats", "Lcom/jetbrains/python/profiler/Stats;", "sendRequest", "T", "request", "Lcom/jetbrains/python/profiler/ProfilerRequest;", "f", "Lkotlin/Function1;", "writeMessage", "Companion", "intellij.python.profiler"})
public final class ProfilerCommunication {
    @Nullable
    private DataOutputStream writer;
    @NotNull
    private final HashMap<Integer, SettableFuture<ProfilerResponse>> responses;
    @NotNull
    private final Project project;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final ServerSocket serverSocket;
    @Nullable
    private final ProcessHandler processHandler;
    private static int id;
    public static final Companion Companion;

    @Nullable
    public final DataOutputStream getWriter() {
        return this.writer;
    }

    public final void setWriter(@Nullable DataOutputStream dataOutputStream) {
        this.writer = dataOutputStream;
    }

    @NotNull
    public final HashMap<Integer, SettableFuture<ProfilerResponse>> getResponses() {
        return this.responses;
    }

    public final void acceptConnection() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ ProfilerCommunication this$0;

            public final void run() {
                Socket socket;
                Socket socket2 = socket = this.this$0.getServerSocket().accept();
                Intrinsics.checkExpressionValueIsNotNull((Object)socket2, (String)"socket");
                this.this$0.setWriter(new DataOutputStream(socket2.getOutputStream()));
                DataInputStream reader = new DataInputStream(socket.getInputStream());
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, reader, socket){
                    final /* synthetic */ acceptConnection.1 this$0;
                    final /* synthetic */ DataInputStream $reader;
                    final /* synthetic */ Socket $socket;

                    public final void run() {
                        while (true) {
                            try {
                                ProfilerResponse response = ProfilerCommunicationKt.readProfilerResponse(this.$reader);
                                SettableFuture<ProfilerResponse> responseProcessor = this.this$0.this$0.getResponses().get(response.getId());
                                if (responseProcessor != null) {
                                    responseProcessor.set((Object)response);
                                    continue;
                                }
                                ProfilerCommunicationKt.processResponse(this.this$0.this$0.getProject(), this.this$0.this$0.getSdk(), response, this.this$0.this$0.getProcessHandler());
                            }
                            catch (EOFException e) {
                                this.$socket.close();
                                break;
                            }
                            catch (SocketException e) {
                                this.$socket.close();
                                break;
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$reader = dataInputStream;
                        this.$socket = socket;
                    }
                });
            }
            {
                this.this$0 = profilerCommunication;
            }
        });
    }

    @NotNull
    public final ListenableFuture<Stats> requestStats() {
        ProfilerRequest request;
        ProfilerRequest profilerRequest = request = new ProfilerRequest(Companion.nextId()).setYstats(new Stats_Req());
        Intrinsics.checkExpressionValueIsNotNull((Object)profilerRequest, (String)"request");
        return this.sendRequest(profilerRequest, requestStats.1.INSTANCE);
    }

    @NotNull
    public final ListenableFuture<ProfilerResponse> captureSnapshot() {
        ProfilerRequest request;
        ProfilerRequest profilerRequest = request = new ProfilerRequest(Companion.nextId()).setSave_snapshot(new SaveSnapshot_Req(ProfilerCommunicationKt.generateSnapshotPath(this.project)));
        Intrinsics.checkExpressionValueIsNotNull((Object)profilerRequest, (String)"request");
        return this.sendRequest(profilerRequest, captureSnapshot.1.INSTANCE);
    }

    @NotNull
    public final <T> ListenableFuture<T> sendRequest(@NotNull ProfilerRequest request, @NotNull Function1<? super ProfilerResponse, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        SettableFuture future = SettableFuture.create();
        this.responses.put(request.getId(), (SettableFuture<ProfilerResponse>)future);
        this.writeMessage(request);
        Function1<? super ProfilerResponse, ? extends T> function1 = f;
        ListenableFuture listenableFuture = Futures.transform((ListenableFuture)((ListenableFuture)future), (Function)new ProfilerCommunicationKt$sam$com_google_common_base_Function$0(function1), (Executor)sendRequest.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)listenableFuture, (String)"Futures.transform(future\u2026nPooledThread(command) })");
        return listenableFuture;
    }

    public final void writeMessage(@NotNull ProfilerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        TSerializer serializer = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
        byte[] bytes = serializer.serialize((TBase)request);
        DataOutputStream dataOutputStream = this.writer;
        if (dataOutputStream == null) {
            Intrinsics.throwNpe();
        }
        dataOutputStream.writeInt(bytes.length);
        DataOutputStream dataOutputStream2 = this.writer;
        if (dataOutputStream2 == null) {
            Intrinsics.throwNpe();
        }
        dataOutputStream2.write(bytes);
        DataOutputStream dataOutputStream3 = this.writer;
        if (dataOutputStream3 == null) {
            Intrinsics.throwNpe();
        }
        dataOutputStream3.flush();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    @NotNull
    public final ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Nullable
    public final ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    public ProfilerCommunication(@NotNull Project project, @NotNull Sdk sdk, @NotNull ServerSocket serverSocket, @Nullable ProcessHandler processHandler) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
        Intrinsics.checkParameterIsNotNull((Object)serverSocket, (String)"serverSocket");
        this.project = project;
        this.sdk = sdk;
        this.serverSocket = serverSocket;
        this.processHandler = processHandler;
        ProfilerCommunication profilerCommunication = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        profilerCommunication.responses = hashMap;
        this.acceptConnection();
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/profiler/ProfilerCommunication$Companion;", "", "()V", "id", "", "getId", "()I", "setId", "(I)V", "nextId", "intellij.python.profiler"})
    public static final class Companion {
        public final int getId() {
            return id;
        }

        public final void setId(int n) {
            id = n;
        }

        public final int nextId() {
            Companion companion = this;
            int n = companion.getId();
            companion.setId(n + 1);
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

