/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.sorting;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.completion.sorting.ItemRankInfo;
import com.intellij.completion.sorting.MLSorterKt;
import com.intellij.completion.sorting.MyMovedLookupElement;
import com.intellij.completion.sorting.RankingSupport;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.stats.completion.CompletionUtil;
import com.intellij.stats.completion.LookupExtensionsKt;
import com.intellij.stats.completion.RelevanceUtil;
import com.intellij.stats.experiment.EmulatedExperiment;
import com.intellij.stats.experiment.WebServiceStatus;
import com.intellij.stats.personalization.UserFactorsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001d\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JT\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u00052\u001c\u0010\u000e\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JY\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J4\u0010\u001f\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00100\u000f0\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!H\u0016J\u0016\u0010\"\u001a\u00020#2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0002J\u0016\u0010%\u001a\u00020#2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000bH\u0002J(\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050$2\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J6\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010*\u001a\u00020+H\u0002J,\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050$*\b\u0012\u0004\u0012\u00020\u00050$2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/completion/sorting/MLSorter;", "Lcom/intellij/codeInsight/completion/CompletionFinalSorter;", "()V", "cachedScore", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lcom/intellij/completion/sorting/ItemRankInfo;", "webServiceStatus", "Lcom/intellij/stats/experiment/WebServiceStatus;", "buildRelevanceMap", "", "", "", "lookupElement", "relevanceObjects", "", "Lcom/intellij/openapi/util/Pair;", "prefixLength", "", "position", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "calculateElementRank", "", "ranker", "Lcom/intellij/completion/sorting/RankingSupport$LanguageRanker;", "element", "relevance", "userFactors", "(Lcom/intellij/completion/sorting/RankingSupport$LanguageRanker;Lcom/intellij/codeInsight/lookup/LookupElement;ILjava/util/Map;Ljava/util/Map;I)Ljava/lang/Double;", "getCachedRankInfo", "getRelevanceObjects", "items", "", "hasUnknownFeatures", "", "", "isCacheValid", "shouldSortByMlRank", "languageName", "sort", "sortByMLRanking", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "addDiagnosticsIfNeeded", "positionsBefore", "intellij.statsCollector"})
public final class MLSorter
extends CompletionFinalSorter {
    private final WebServiceStatus webServiceStatus = WebServiceStatus.Companion.getInstance();
    private final Map<LookupElement, ItemRankInfo> cachedScore = new IdentityHashMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<LookupElement, List<com.intellij.openapi.util.Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (this.cachedScore.isEmpty()) {
            void $this$associateTo$iv$iv;
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object t : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = (LookupElement)t;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"NONE")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (this.hasUnknownFeatures(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"UNDEFINED")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (!this.isCacheValid(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"INVALID_CACHE")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        Iterable<? extends LookupElement> $this$associate$iv = items;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (LookupElement lookupElement : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            LookupElement it = lookupElement;
            boolean bl = false;
            boolean bl2 = false;
            List result = new ArrayList();
            ItemRankInfo cached = this.cachedScore.get(it);
            if (cached != null) {
                com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)cached.getMlRank());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(FeatureUtils.ML_RANK, cached.mlRank)");
                result.add(pair);
                com.intellij.openapi.util.Pair pair2 = com.intellij.openapi.util.Pair.create((Object)"before_rerank_order", (Object)cached.getPositionBefore());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(FeatureUtils\u2026R, cached.positionBefore)");
                result.add(pair2);
            }
            Pair pair = TuplesKt.to((Object)it, (Object)result);
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCacheValid(Iterable<? extends LookupElement> items) {
        void $this$mapTo$iv$iv;
        Iterable<? extends LookupElement> $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable<? extends LookupElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LookupElement lookupElement = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemRankInfo itemRankInfo = this.cachedScore.get(it);
            Integer n = itemRankInfo != null ? Integer.valueOf(itemRankInfo.getPrefixLength()) : null;
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    private final boolean hasUnknownFeatures(Iterable<? extends LookupElement> items) {
        boolean bl;
        block3: {
            Iterable<? extends LookupElement> $this$any$iv = items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends LookupElement> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    ItemRankInfo score;
                    LookupElement element$iv;
                    LookupElement it = element$iv = iterator.next();
                    boolean bl2 = false;
                    ItemRankInfo itemRankInfo = score = this.cachedScore.get(it);
                    boolean bl3 = (itemRankInfo != null ? itemRankInfo.getMlRank() : null) == null;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public Iterable<LookupElement> sort(@NotNull Iterable<? extends LookupElement> items, @NotNull CompletionParameters parameters) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        RankingSupport.LanguageRanker languageRanker = RankingSupport.INSTANCE.getRanker(MLSorterKt.language(parameters));
        if (languageRanker == null || !this.shouldSortByMlRank(languageRanker.getDisplayName())) {
            return items;
        }
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (!(lookupEx instanceof LookupImpl)) {
            lookupEx = null;
        }
        LookupImpl lookupImpl = (LookupImpl)lookupEx;
        if (lookupImpl == null) {
            return items;
        }
        LookupImpl lookup = lookupImpl;
        long startTime = System.currentTimeMillis();
        Iterable<LookupElement> iterable = this.sortByMLRanking(languageRanker, parameters, CollectionsKt.filterNotNull(items), lookup);
        if (iterable == null) {
            return items;
        }
        Iterable<LookupElement> sorted = iterable;
        long timeSpent = System.currentTimeMillis() - startTime;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            Long l = (Long)lookup.getUserData(CompletionUtil.INSTANCE.getML_SORTING_CONTRIBUTION_KEY());
            if (l == null) {
                l = 0L;
            }
            long totalTime = timeSpent + l;
            lookup.putUserData(CompletionUtil.INSTANCE.getML_SORTING_CONTRIBUTION_KEY(), (Object)totalTime);
        }
        return sorted;
    }

    private final boolean shouldSortByMlRank(String languageName) {
        Application application;
        Application application2 = application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"application");
        if (application2.isUnitTestMode()) {
            return false;
        }
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        CompletionMLRankingSettings settings = completionMLRankingSettings;
        if (application.isEAP() && this.webServiceStatus.isExperimentOnCurrentIDE() && settings.isCompletionLogsSendAllowed()) {
            return EmulatedExperiment.Companion.shouldRank(this.webServiceStatus.experimentVersion());
        }
        return settings.isRankingEnabled() && settings.isLanguageEnabled(languageName);
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> sortByMLRanking(RankingSupport.LanguageRanker ranker, CompletionParameters parameters, Iterable<? extends LookupElement> items, LookupImpl lookup) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedByDescending$iv;
        LookupElement lookupElement;
        Collection<LookupElement> collection;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Map map = lookup.getRelevanceObjects(items, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"lookup.getRelevanceObjects(items, false)");
        Map relevanceObjects = map;
        int prefixLength = LookupExtensionsKt.prefixLength(lookup);
        Map map2 = (Map)lookup.getUserData(UserFactorsManager.Companion.getUSER_FACTORS_KEY());
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"lookup.getUserData(UserF\u2026ACTORS_KEY) ?: emptyMap()");
        Map userFactors = map2;
        boolean bl = false;
        Map positionsBefore = new LinkedHashMap();
        Iterable<? extends LookupElement> iterable = items;
        MLSorter mLSorter = this;
        boolean $i$f$mapIndexed = false;
        void var11_13 = $this$mapIndexed$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            Map<String, Object> relevance;
            void position;
            void lookupElement2;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv22;
            boolean bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            LookupElement lookupElement3 = (LookupElement)item$iv$iv2;
            int n3 = n2;
            collection = collection2;
            boolean bl3 = false;
            positionsBefore.put(lookupElement2, (int)position);
            if (this.buildRelevanceMap((LookupElement)lookupElement2, (List)relevanceObjects.get(lookupElement2), LookupExtensionsKt.prefixLength(lookup), (int)position, parameters) == null) {
                return null;
            }
            Double d = this.calculateElementRank(ranker, (LookupElement)lookupElement2, (int)position, relevance, userFactors, prefixLength);
            if (d == null) {
                return null;
            }
            double rank = d;
            lookupElement = TuplesKt.to((Object)lookupElement2, (Object)rank);
            collection.add(lookupElement);
        }
        collection = (List)destination$iv$iv22;
        $this$mapIndexed$iv = collection;
        boolean $i$f$sortedByDescending = false;
        $this$mapIndexedTo$iv$iv = $this$sortedByDescending$iv;
        boolean destination$iv$iv22 = false;
        Comparator $i$f$mapIndexedTo22 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(((Number)it.getSecond()).doubleValue());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = ((Number)it.getSecond()).doubleValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        collection = CollectionsKt.sortedWith((Iterable)$this$mapIndexedTo$iv$iv, (Comparator)$i$f$mapIndexedTo22);
        $this$sortedByDescending$iv = collection;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            lookupElement = (LookupElement)it.getFirst();
            collection.add(lookupElement);
        }
        collection = (List)destination$iv$iv;
        return mLSorter.addDiagnosticsIfNeeded((Iterable<? extends LookupElement>)collection, positionsBefore);
    }

    private final Map<String, Object> buildRelevanceMap(LookupElement lookupElement, List<? extends com.intellij.openapi.util.Pair<String, Object>> relevanceObjects, int prefixLength, int position, CompletionParameters parameters) {
        if (relevanceObjects == null) {
            return null;
        }
        Map<String, Object> relevanceMap = RelevanceUtil.INSTANCE.asRelevanceMap(relevanceObjects);
        relevanceMap.put("position", position);
        relevanceMap.put("query_length", prefixLength);
        relevanceMap.put("result_length", lookupElement.getLookupString().length());
        relevanceMap.put("auto_popup", parameters.isAutoPopup());
        relevanceMap.put("completion_type", parameters.getCompletionType().toString());
        relevanceMap.put("invocation_count", parameters.getInvocationCount());
        return relevanceMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> addDiagnosticsIfNeeded(@NotNull Iterable<? extends LookupElement> $this$addDiagnosticsIfNeeded, Map<LookupElement, Integer> positionsBefore) {
        if (Registry.is((String)"completion.stats.show.ml.ranking.diff")) {
            void $this$mapIndexedTo$iv$iv;
            Iterable<LookupElement> $this$mapIndexed$iv = $this$addDiagnosticsIfNeeded;
            boolean $i$f$mapIndexed = false;
            Iterable<LookupElement> iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void element;
                void position;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                LookupElement lookupElement = (LookupElement)item$iv$iv;
                int n3 = n2;
                Collection collection2 = collection;
                boolean bl2 = false;
                void diff = position - ((Number)MapsKt.getValue(positionsBefore, (Object)element)).intValue();
                void var20_20 = diff != false ? (LookupElement)new MyMovedLookupElement((LookupElement)element, (int)diff) : element;
                collection2.add(var20_20);
            }
            return (List)destination$iv$iv;
        }
        return $this$addDiagnosticsIfNeeded;
    }

    private final ItemRankInfo getCachedRankInfo(LookupElement element, int prefixLength, int position) {
        ItemRankInfo cached = this.cachedScore.get(element);
        if (cached != null && prefixLength == cached.getPrefixLength() && cached.getPositionBefore() == position) {
            return cached;
        }
        return null;
    }

    private final Double calculateElementRank(RankingSupport.LanguageRanker ranker, LookupElement element, int position, Map<String, ? extends Object> relevance, Map<String, ? extends Object> userFactors, int prefixLength) {
        ItemRankInfo cachedWeight = this.getCachedRankInfo(element, prefixLength, position);
        if (cachedWeight != null) {
            return cachedWeight.getMlRank();
        }
        List<String> unknownFactors = ranker.unknownFeatures(relevance.keySet());
        Double mlRank = unknownFactors.isEmpty() ? Double.valueOf(ranker.rank(relevance, userFactors)) : null;
        ItemRankInfo info = new ItemRankInfo(position, mlRank, prefixLength);
        this.cachedScore.put(element, info);
        return info.getMlRank();
    }
}

