/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.metadata.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.angular2.lang.metadata.MetadataJsonFileType;
import org.angular2.lang.metadata.MetadataJsonLanguage;
import org.angular2.lang.metadata.stubs.MetadataFileStubImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MetadataFileImpl
extends PsiBinaryFileImpl
implements PsiFileWithStubSupport,
PsiFileEx {
    @NonNls
    private static final Logger LOG = Logger.getInstance(MetadataFileImpl.class);
    private volatile SoftReference<StubTree> myStub;
    private final Object myStubLock = new Object();
    private final MetadataJsonFileType myFileType;

    public MetadataFileImpl(FileViewProvider fileViewProvider, MetadataJsonFileType fileType) {
        super((PsiManagerImpl)fileViewProvider.getManager(), fileViewProvider);
        this.myFileType = fileType;
    }

    public PsiFile getContainingFile() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return this;
    }

    @NotNull
    public Language getLanguage() {
        MetadataJsonLanguage metadataJsonLanguage = MetadataJsonLanguage.INSTANCE;
        if (metadataJsonLanguage == null) {
            MetadataFileImpl.$$$reportNull$$$0(0);
        }
        return metadataJsonLanguage;
    }

    @NotNull
    public PsiElement[] getChildren() {
        MetadataFileStubImpl root = (MetadataFileStubImpl)this.getStubTree().getRoot();
        PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Collection)root.getChildrenStubs(), PsiElement.class, s -> s.getPsi());
        if (psiElementArray == null) {
            MetadataFileImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public StubTree getStubTree() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        StubTree stubTree = (StubTree)SoftReference.dereference(this.myStub);
        if (stubTree != null) {
            StubTree stubTree2 = stubTree;
            if (stubTree2 == null) {
                MetadataFileImpl.$$$reportNull$$$0(2);
            }
            return stubTree2;
        }
        StubTree newStubTree = (StubTree)StubTreeLoader.getInstance().readOrBuild(this.getProject(), this.getVirtualFile(), (PsiFile)this);
        if (newStubTree == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No stub for class file in index: " + this.getVirtualFile().getPresentableUrl());
            }
            newStubTree = new StubTree((PsiFileStub)new MetadataFileStubImpl(this, this.myFileType.getFileElementType()));
        }
        Object object = this.myStubLock;
        synchronized (object) {
            stubTree = (StubTree)SoftReference.dereference(this.myStub);
            if (stubTree != null) {
                StubTree stubTree3 = stubTree;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (stubTree3 == null) {
                    MetadataFileImpl.$$$reportNull$$$0(3);
                }
                return stubTree3;
            }
            stubTree = newStubTree;
            PsiFileStubImpl fileStub = (PsiFileStubImpl)stubTree.getRoot();
            fileStub.setPsi((PsiFile)this);
            this.myStub = new SoftReference((Object)stubTree);
        }
        StubTree stubTree4 = stubTree;
        if (stubTree4 == null) {
            MetadataFileImpl.$$$reportNull$$$0(4);
        }
        return stubTree4;
    }

    @NotNull
    public StubbedSpine getStubbedSpine() {
        StubbedSpine stubbedSpine = this.getStubTree().getSpine();
        if (stubbedSpine == null) {
            MetadataFileImpl.$$$reportNull$$$0(5);
        }
        return stubbedSpine;
    }

    public boolean isContentsLoaded() {
        return this.myStub != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onContentReload() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Object object = this.myStubLock;
        synchronized (object) {
            StubTree stubTree = (StubTree)SoftReference.dereference(this.myStub);
            this.myStub = null;
            if (stubTree != null) {
                ((PsiFileStubImpl)stubTree.getRoot()).clearPsi("metadata onContentReload");
            }
        }
    }

    @NonNls
    public String toString() {
        return "MetadataFile:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/angular2/lang/metadata/psi/MetadataFileImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubbedSpine";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

