/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.inspections.quickfixes.AddJSPropertyQuickFix;
import org.angular2.inspections.quickfixes.RemoveJSProperty;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

public class AngularIncorrectTemplateDefinitionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularIncorrectTemplateDefinitionInspection.$$$reportNull$$$0(0);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6Decorator(ES6Decorator decorator) {
                if (Angular2DecoratorUtil.isAngularDecorator(decorator, "Component")) {
                    JSObjectLiteralExpression initializer = Angular2DecoratorUtil.getObjectLiteralInitializer(decorator);
                    if (initializer == null) {
                        return;
                    }
                    JSProperty templateUrl = initializer.findProperty("templateUrl");
                    JSProperty template = initializer.findProperty("template");
                    if (template == null && templateUrl == null) {
                        Angular2Component component = Angular2EntitiesProvider.getComponent((PsiElement)decorator);
                        if (component != null && component.getTypeScriptClass() != null && component.getTypeScriptClass().getName() != null) {
                            holder.registerProblem((PsiElement)initializer, Angular2Bundle.message("angular.inspection.decorator.missing-template", component.getTypeScriptClass().getName()), new LocalQuickFix[]{new AddJSPropertyQuickFix(initializer, "template", "\n\n", 1, true), new AddJSPropertyQuickFix(initializer, "templateUrl", "./", 2, false)});
                        }
                    } else if (template != null && templateUrl != null) {
                        ContainerUtil.packNullables((Object[])new PsiElement[]{template.getNameIdentifier(), templateUrl.getNameIdentifier()}).forEach(id -> holder.registerProblem(id, Angular2Bundle.message("angular.inspection.decorator.duplicated-template", new Object[0]), new LocalQuickFix[]{new RemoveJSProperty(StringUtil.unquoteString((String)id.getText()))}));
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            AngularIncorrectTemplateDefinitionInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/AngularIncorrectTemplateDefinitionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/AngularIncorrectTemplateDefinitionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

