/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities.metadata.stubs;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.angular2.entities.metadata.Angular2MetadataElementTypes;
import org.angular2.entities.metadata.psi.Angular2MetadataModuleExport;
import org.angular2.entities.metadata.stubs.Angular2MetadataElementStub;
import org.angular2.lang.metadata.MetadataUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2MetadataModuleExportStub
extends Angular2MetadataElementStub<Angular2MetadataModuleExport> {
    @NonNls
    private static final String FROM = "from";
    @NonNls
    private static final String EXPORT = "export";
    @NonNls
    private static final String AS = "as";
    @NonNls
    private static final String NAME = "name";
    private static final BooleanStructureElement HAS_EXPORT_MAPPINGS = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(Angular2MetadataElementStub.FLAGS_STRUCTURE, new FlagsStructureElement[]{HAS_EXPORT_MAPPINGS});
    private final StringRef myFrom;
    private final Map<String, String> myExportMappings;

    public Angular2MetadataModuleExportStub(@NotNull StubElement parent, @NotNull JsonObject source) {
        if (parent == null) {
            Angular2MetadataModuleExportStub.$$$reportNull$$$0(0);
        }
        if (source == null) {
            Angular2MetadataModuleExportStub.$$$reportNull$$$0(1);
        }
        super((String)null, parent, Angular2MetadataElementTypes.MODULE_EXPORT);
        this.myFrom = StringRef.fromString((String)MetadataUtils.readStringPropertyValue(source.findProperty(FROM)));
        this.myExportMappings = StreamEx.ofNullable((Object)source.findProperty(EXPORT)).map(JsonProperty::getValue).select(JsonArray.class).flatCollection(JsonArray::getValueList).select(JsonObject.class).map(obj -> {
            String name = MetadataUtils.readStringPropertyValue(obj.findProperty(NAME));
            String as = MetadataUtils.readStringPropertyValue(obj.findProperty(AS));
            return name == null || as == null ? null : Pair.pair((Object)as, (Object)name);
        }).nonNull().mapToEntry(p -> (String)p.first, p -> (String)p.second).toImmutableMap();
    }

    public Angular2MetadataModuleExportStub(@NotNull StubInputStream stream, @Nullable StubElement parent) throws IOException {
        if (stream == null) {
            Angular2MetadataModuleExportStub.$$$reportNull$$$0(2);
        }
        super(stream, parent, Angular2MetadataElementTypes.MODULE_EXPORT);
        this.myFrom = stream.readName();
        this.myExportMappings = (Boolean)this.readFlag(HAS_EXPORT_MAPPINGS) != false ? Collections.unmodifiableMap(Angular2MetadataModuleExportStub.readStringMap(stream)) : Collections.emptyMap();
    }

    @Override
    public void serialize(@NotNull StubOutputStream stream) throws IOException {
        if (stream == null) {
            Angular2MetadataModuleExportStub.$$$reportNull$$$0(3);
        }
        this.writeFlag(HAS_EXPORT_MAPPINGS, !this.myExportMappings.isEmpty());
        super.serialize(stream);
        Angular2MetadataModuleExportStub.writeString(this.myFrom, stream);
        if (!this.myExportMappings.isEmpty()) {
            Angular2MetadataModuleExportStub.writeStringMap(this.myExportMappings, stream);
        }
    }

    @Nullable
    public String getFrom() {
        return StringRef.toString((StringRef)this.myFrom);
    }

    @NotNull
    public Map<String, String> getExportMappings() {
        Map<String, String> map = this.myExportMappings;
        if (map == null) {
            Angular2MetadataModuleExportStub.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Override
    protected FlagsStructure getFlagsStructure() {
        return FLAGS_STRUCTURE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/entities/metadata/stubs/Angular2MetadataModuleExportStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/entities/metadata/stubs/Angular2MetadataModuleExportStub";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

