/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.attributes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.angular2.codeInsight.template.Angular2TemplateElementsScopeProvider;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Entity;
import org.angular2.lang.expr.psi.Angular2TemplateBindings;
import org.angular2.lang.selector.Angular2DirectiveSimpleSelector;
import org.angular2.lang.selector.Angular2SelectorMatcher;
import org.jetbrains.annotations.NotNull;

public class Angular2ApplicableDirectivesProvider {
    private final NotNullLazyValue<List<Angular2Directive>> myDirectiveCandidates;
    private final List<Angular2Directive> myMatchedDirectives;

    public Angular2ApplicableDirectivesProvider(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            Angular2ApplicableDirectivesProvider.$$$reportNull$$$0(0);
        }
        this(xmlTag, false);
    }

    public Angular2ApplicableDirectivesProvider(@NotNull XmlTag xmlTag, boolean onlyMatchingTagName) {
        if (xmlTag == null) {
            Angular2ApplicableDirectivesProvider.$$$reportNull$$$0(1);
        }
        this(xmlTag.getProject(), xmlTag.getLocalName(), onlyMatchingTagName, Angular2DirectiveSimpleSelector.createElementCssSelector(xmlTag));
    }

    public Angular2ApplicableDirectivesProvider(@NotNull Angular2TemplateBindings bindings) {
        if (bindings == null) {
            Angular2ApplicableDirectivesProvider.$$$reportNull$$$0(2);
        }
        this(bindings.getProject(), "ng-template", false, Angular2DirectiveSimpleSelector.createTemplateBindingsCssSelector(bindings));
    }

    private Angular2ApplicableDirectivesProvider(@NotNull Project project, @NotNull String tagName, boolean onlyMatchingTagName, @NotNull Angular2DirectiveSimpleSelector cssSelector) {
        if (project == null) {
            Angular2ApplicableDirectivesProvider.$$$reportNull$$$0(3);
        }
        if (tagName == null) {
            Angular2ApplicableDirectivesProvider.$$$reportNull$$$0(4);
        }
        if (cssSelector == null) {
            Angular2ApplicableDirectivesProvider.$$$reportNull$$$0(5);
        }
        HashSet<Angular2Directive> directiveCandidates = new HashSet<Angular2Directive>(Angular2EntitiesProvider.findElementDirectivesCandidates(project, tagName));
        if (!onlyMatchingTagName) {
            directiveCandidates.addAll(Angular2EntitiesProvider.findElementDirectivesCandidates(project, ""));
        }
        Angular2SelectorMatcher<Angular2Directive> matcher = new Angular2SelectorMatcher<Angular2Directive>();
        directiveCandidates.forEach(d -> matcher.addSelectables(d.getSelector().getSimpleSelectors(), (Angular2Directive)d));
        this.myDirectiveCandidates = NotNullLazyValue.createValue(() -> new ArrayList(directiveCandidates));
        boolean isTemplateTag = Angular2TemplateElementsScopeProvider.isTemplateTag(tagName);
        HashSet matchedDirectives = new HashSet();
        matcher.match(cssSelector, (selector, directive) -> {
            if (directive.isRegularDirective() || isTemplateTag) {
                matchedDirectives.add(directive);
            }
        });
        this.myMatchedDirectives = ContainerUtil.sorted(matchedDirectives, Comparator.comparing(Angular2Entity::getName));
    }

    public List<Angular2Directive> getCandidates() {
        return (List)this.myDirectiveCandidates.getValue();
    }

    public List<Angular2Directive> getMatched() {
        return this.myMatchedDirectives;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "xmlTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "bindings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "tagName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "cssSelector";
                break;
            }
        }
        objectArray[1] = "org/angular2/codeInsight/attributes/Angular2ApplicableDirectivesProvider";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

