/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.ServiceGlobalModeOptions;
import com.github.dockerjava.api.model.ServiceMode;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ServiceModeConfig
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Replicated")
    private ServiceReplicatedModeOptions replicated;
    @JsonProperty(value="Global")
    private ServiceGlobalModeOptions global;

    @CheckForNull
    public ServiceMode getMode() {
        if (this.replicated != null) {
            return ServiceMode.REPLICATED;
        }
        if (this.global != null) {
            return ServiceMode.GLOBAL;
        }
        return null;
    }

    @CheckForNull
    public ServiceReplicatedModeOptions getReplicated() {
        return this.replicated;
    }

    public ServiceModeConfig withReplicated(ServiceReplicatedModeOptions replicated) {
        if (replicated != null && this.global != null) {
            throw new IllegalStateException("Cannot set both replicated and global mode");
        }
        this.replicated = replicated;
        return this;
    }

    @CheckForNull
    public ServiceGlobalModeOptions getGlobal() {
        return this.global;
    }

    public ServiceModeConfig withGlobal(ServiceGlobalModeOptions global) {
        if (global != null && this.replicated != null) {
            throw new IllegalStateException("Cannot set both global and replicated mode");
        }
        this.global = global;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

