/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.slicer;

import com.intellij.database.model.DasRoutine;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.GroupByLeavesAction;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.slicer.SqlSliceProvider;
import com.intellij.sql.slicer.SqlSliceUsage;
import com.intellij.sql.slicer.SqlSliceUsageCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/sql/slicer/SqlSliceProvider;", "Lcom/intellij/slicer/SliceLanguageSupportProvider;", "()V", "createLeafAnalyzer", "Lcom/intellij/slicer/SliceLeafAnalyzer;", "createRootUsage", "Lcom/intellij/slicer/SliceUsage;", "element", "Lcom/intellij/psi/PsiElement;", "params", "Lcom/intellij/slicer/SliceAnalysisParams;", "getElementForDescription", "getExpressionAtCaret", "atCaret", "dataFlowToThis", "", "getRenderer", "Lcom/intellij/slicer/SliceUsageCellRendererBase;", "registerExtraPanelActions", "", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "builder", "Lcom/intellij/slicer/SliceTreeBuilder;", "startAnalyzeLeafValues", "structure", "Lcom/intellij/ide/util/treeView/AbstractTreeStructure;", "finalRunnable", "Ljava/lang/Runnable;", "startAnalyzeNullness", "Companion", "SqlSliceLeafEquality", "intellij.database.sql.impl"})
public final class SqlSliceProvider
implements SliceLanguageSupportProvider {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public SliceUsage createRootUsage(@NotNull PsiElement element2, @NotNull SliceAnalysisParams params) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        return new SqlSliceUsage(element2, params);
    }

    @Nullable
    public PsiElement getExpressionAtCaret(@NotNull PsiElement atCaret, boolean dataFlowToThis) {
        Intrinsics.checkParameterIsNotNull((Object)atCaret, (String)"atCaret");
        PsiElement element2 = (PsiElement)SqlImplUtil.sqlParents(atCaret).filter((Condition)getExpressionAtCaret.element.1.INSTANCE).first();
        if (dataFlowToThis) {
            if (element2 instanceof SqlLiteralExpression) {
                return null;
            }
            if (element2 instanceof SqlProcedureDefinitionImpl && ((SqlProcedureDefinitionImpl)element2).getRoutineKind() != DasRoutine.Kind.FUNCTION) {
                return null;
            }
        }
        return element2;
    }

    @NotNull
    public PsiElement getElementForDescription(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return SqlSliceProvider.Companion.getSqlReferenceTargetOrThis(element2);
    }

    @NotNull
    public SliceUsageCellRendererBase getRenderer() {
        return new SqlSliceUsageCellRenderer();
    }

    public void startAnalyzeLeafValues(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        Intrinsics.checkParameterIsNotNull((Object)structure, (String)"structure");
        Intrinsics.checkParameterIsNotNull((Object)finalRunnable, (String)"finalRunnable");
        this.createLeafAnalyzer().startAnalyzeValues(structure, finalRunnable);
    }

    public void startAnalyzeNullness(@NotNull AbstractTreeStructure structure, @NotNull Runnable finalRunnable) {
        Intrinsics.checkParameterIsNotNull((Object)structure, (String)"structure");
        Intrinsics.checkParameterIsNotNull((Object)finalRunnable, (String)"finalRunnable");
        finalRunnable.run();
    }

    public void registerExtraPanelActions(@NotNull DefaultActionGroup group2, @NotNull SliceTreeBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        if (builder.dataFlowToThis) {
            group2.add((AnAction)new GroupByLeavesAction(builder));
        }
    }

    private final SliceLeafAnalyzer createLeafAnalyzer() {
        return new SliceLeafAnalyzer((SliceLeafEquality)SqlSliceLeafEquality.INSTANCE, (SliceLanguageSupportProvider)this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/slicer/SqlSliceProvider$SqlSliceLeafEquality;", "Lcom/intellij/slicer/SliceLeafEquality;", "()V", "substituteElement", "Lcom/intellij/psi/PsiElement;", "element", "intellij.database.sql.impl"})
    public static final class SqlSliceLeafEquality
    extends SliceLeafEquality {
        public static final SqlSliceLeafEquality INSTANCE;

        @NotNull
        protected PsiElement substituteElement(@NotNull PsiElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return Companion.getSqlReferenceTargetOrThis(element2);
        }

        private SqlSliceLeafEquality() {
        }

        static {
            SqlSliceLeafEquality sqlSliceLeafEquality;
            INSTANCE = sqlSliceLeafEquality = new SqlSliceLeafEquality();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005*\u00020\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/slicer/SqlSliceProvider$Companion;", "", "()V", "getSqlReferenceTargetOrThis", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "intellij.database.sql.impl"})
    public static final class Companion {
        private final PsiElement getSqlReferenceTargetOrThis(@NotNull PsiElement $this$getSqlReferenceTargetOrThis) {
            SqlReferenceExpression sqlReferenceExpression;
            PsiElement psiElement = $this$getSqlReferenceTargetOrThis;
            if (!(psiElement instanceof SqlReferenceExpression)) {
                psiElement = null;
            }
            if ((sqlReferenceExpression = (SqlReferenceExpression)psiElement) == null || (sqlReferenceExpression = sqlReferenceExpression.resolve()) == null) {
                sqlReferenceExpression = $this$getSqlReferenceTargetOrThis;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression, (String)"(this as? SqlReferenceEx\u2026ssion)?.resolve() ?: this");
            return sqlReferenceExpression;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

