/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        return SqlLanguageSubstitutor.getSqlLanguage(file, project);
    }

    @NotNull
    public static SqlLanguageDialect getSqlLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(3);
        }
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)ObjectUtils.chooseNotNull((Object)SqlLanguageSubstitutor.getConfiguredSqlLanguageDialect(file, project, false), (Object)SqlDialectMappings.getDefaultSqlDialect());
        if (sqlLanguageDialect == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public static SqlLanguageDialect getSqlLanguageDialect(@Nullable VirtualFile file, @Nullable Project project) {
        Language language;
        FileType fileType = file == null ? null : file.getFileType();
        SqlLanguage fileLang = fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : SqlLanguage.INSTANCE;
        Language language2 = language = file == null || project == null ? null : LanguageSubstitutors.INSTANCE.substituteLanguage((Language)fileLang, file, project);
        if (language instanceof SqlLanguageDialect) {
            SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)language;
            if (sqlLanguageDialect == null) {
                SqlLanguageSubstitutor.$$$reportNull$$$0(5);
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getMapping(project, file);
        if (sqlLanguageDialect == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(6);
        }
        return sqlLanguageDialect;
    }

    @Nullable
    public static SqlLanguageDialect getConfiguredSqlLanguageDialect(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(7);
        }
        return SqlLanguageSubstitutor.getConfiguredSqlLanguageDialect(file, project, true);
    }

    @Nullable
    public static SqlLanguageDialect getConfiguredSqlLanguageDialect(@Nullable VirtualFile file, @NotNull Project project, boolean direct) {
        SqlLanguageDialect language;
        VirtualFile originalFile;
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(8);
        }
        while (file instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)file).getOriginalFile()) != null) {
            file = originalFile;
        }
        if (DbSrcUtils.isDbSrcFile(file)) {
            language = (SqlLanguageDialect)SqlDialectMappings.SQL_DIALECT_KEY.get((UserDataHolder)file);
            return language != null ? language : SqlLanguageSubstitutor.getSqlLanguageFromDataSource(file);
        }
        language = SqlLanguageSubstitutor.getSqlLanguageFromFile(file, project, direct);
        VirtualFile hostFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : null;
        return language != null ? language : SqlLanguageSubstitutor.getSqlLanguageFromMapping(project, hostFile, direct);
    }

    @Nullable
    private static SqlLanguageDialect getSqlLanguageFromFile(@Nullable VirtualFile file, @NotNull Project project, boolean direct) {
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(9);
        }
        if (file instanceof LightVirtualFile) {
            return (SqlLanguageDialect)ObjectUtils.tryCast((Object)((LightVirtualFile)file).getLanguage(), SqlLanguageDialect.class);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return DbSqlUtil.getSqlDialect((DbElement)((DatabaseElementVirtualFileImpl)file).findDataSource(project));
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, file);
        return console == null ? SqlLanguageSubstitutor.getSqlLanguageFromMapping(project, file, direct) : DbSqlUtil.getSqlDialect(console.getDataSource());
    }

    @Nullable
    private static SqlLanguageDialect getSqlLanguageFromDataSource(@NotNull VirtualFile file) {
        LocalDataSource source;
        if (file == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(10);
        }
        return (source = DbSrcUtils.findDataSource(file)) == null ? null : DbSqlUtil.getSqlDialect(source);
    }

    @Nullable
    private static SqlLanguageDialect getSqlLanguageFromMapping(@NotNull Project project, @Nullable VirtualFile file, boolean direct) {
        SqlDialectMappings mappings;
        if (project == null) {
            SqlLanguageSubstitutor.$$$reportNull$$$0(11);
        }
        return (mappings = SqlDialectMappings.getInstance(project)) == null ? null : (direct ? (SqlLanguageDialect)mappings.getDirectlyConfiguredMapping(file) : (SqlLanguageDialect)mappings.getConfiguredMapping(file));
    }

    static {
        SqlDialects.ensureSqlDialectsLoaded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/SqlLanguageSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/SqlLanguageSubstitutor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguageDialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredSqlLanguageDialect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageFromFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageFromDataSource";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSqlLanguageFromMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

