/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/intentions/SqlQuoteIdentifierIntention;", "Lcom/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlQuoteIdentifierIntention
extends BaseElementAtCaretIntentionAction {
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlMessages.message("quickfix.name.quote.identifier", new Object[0]);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiFile file = element2.getContainingFile();
        if (editor == null || !(file instanceof SqlFile)) {
            return false;
        }
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element2);
        if (sqlIdentifier == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlIdentifier, (String)"SqlIntentionUtil.getIden\u2026(element) ?: return false");
        SqlIdentifier identifier = sqlIdentifier;
        return !identifier.isQuotedIdentifier();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element2);
        if (sqlIdentifier == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlIdentifier, (String)"SqlIntentionUtil.getIdentifier(element) ?: return");
        SqlIdentifier identifier = sqlIdentifier;
        SqlImplUtil.quoteIdentifier(project, identifier, SqlImplUtil.getSqlDialectSafe((PsiElement)identifier));
    }
}

