/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlGotoStatement;
import com.intellij.sql.psi.SqlLoopStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/inspections/SqlGotoInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "reportAll", "", "reportBackwardGoto", "reportLoopExit", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "createOptionsPanel", "Ljavax/swing/JComponent;", "intellij.database.sql.impl"})
public final class SqlGotoInspection
extends SqlInspectionBase {
    @JvmField
    public boolean reportAll;
    @JvmField
    public boolean reportLoopExit = true;
    @JvmField
    public boolean reportBackwardGoto = true;

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(this, onTheFly, manager, dialect, result2, manager, dialect, result2){
            final /* synthetic */ SqlGotoInspection this$0;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            public void visitSqlGotoStatement(@NotNull SqlGotoStatement o) {
                SqlLoopStatement loopStatement;
                Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
                if (this.this$0.reportAll) {
                    this.reportProblem((PsiElement)o, "Avoid use of GOTO statements");
                    return;
                }
                SqlReferenceExpression sqlReferenceExpression = o.getLabelReference();
                if (sqlReferenceExpression == null || (sqlReferenceExpression = sqlReferenceExpression.resolve()) == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression, (String)"o.labelReference?.resolve() ?: return");
                SqlReferenceExpression targetElement = sqlReferenceExpression;
                if (this.this$0.reportLoopExit && (loopStatement = (SqlLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlLoopStatement.class)) != null && !PsiTreeUtil.isAncestor((PsiElement)targetElement, (PsiElement)((PsiElement)loopStatement), (boolean)true)) {
                    this.reportProblem((PsiElement)o, "Avoid using GOTO statements to exit a loop");
                }
                if (this.this$0.reportBackwardGoto) {
                    TextRange textRange = targetElement.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"targetElement.textRange");
                    int n = textRange.getStartOffset();
                    TextRange textRange2 = o.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"o.textRange");
                    if (n < textRange2.getStartOffset()) {
                        this.reportProblem((PsiElement)o, "Avoid using backward GOTO statements");
                    }
                }
            }

            private final void reportProblem(PsiElement anchor, String message2) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, message2, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }
            {
                this.this$0 = $outer;
                this.$onTheFly = $captured_local_variable$1;
                this.$manager = $captured_local_variable$2;
                this.$dialect = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        JCheckBox allCheckbox = optionsPanel.addCheckboxEx("Report all GOTO statements", "reportAll");
        List caseCheckboxes = CollectionsKt.listOf((Object[])new JCheckBox[]{optionsPanel.addCheckboxEx("Report uses of GOTO statements to exit a loop", "reportLoopExit"), optionsPanel.addCheckboxEx("Report backward GOTO statements", "reportBackwardGoto")});
        Function0 action2 = (Function0)new Function0<Unit>(caseCheckboxes, allCheckbox){
            final /* synthetic */ List $caseCheckboxes;
            final /* synthetic */ JCheckBox $allCheckbox;

            public final void invoke() {
                Iterable $this$forEach$iv = this.$caseCheckboxes;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JCheckBox checkBox = (JCheckBox)element$iv;
                    boolean bl = false;
                    JCheckBox jCheckBox = checkBox;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jCheckBox, (String)"checkBox");
                    JCheckBox jCheckBox2 = this.$allCheckbox;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jCheckBox2, (String)"allCheckbox");
                    jCheckBox.setEnabled(!jCheckBox2.isSelected());
                }
            }
            {
                this.$caseCheckboxes = list;
                this.$allCheckbox = jCheckBox;
                super(0);
            }
        };
        allCheckbox.addActionListener(new ActionListener(action2){
            final /* synthetic */ Function0 $action;

            public final void actionPerformed(ActionEvent it2) {
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        });
        action2.invoke();
        return (JComponent)optionsPanel;
    }
}

