/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlParenthesizedBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedSubqueryBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/SqlParenthesizedSubqueryBlock;", "Lcom/intellij/sql/formatter/model/SqlParenthesizedBlock;", "()V", "closingBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "defaultIndent", "Lcom/intellij/formatting/Indent;", "openingBlock", "queryBlock", "Lcom/intellij/sql/formatter/model/SqlQueryBlock;", "adjustNestedNodes", "", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "decideSpacing$intellij_database_sql_impl", "defaultChildIndent", "block", "makeBlock", "node", "Lcom/intellij/lang/ASTNode;", "tuneNestedNodesAfterAnalysis", "userRequiresExpand", "", "intellij.database.sql.impl"})
public class SqlParenthesizedSubqueryBlock
extends SqlParenthesizedBlock {
    private SqlBlock openingBlock;
    private SqlBlock closingBlock;
    private SqlQueryBlock queryBlock;
    private Indent defaultIndent = SqlFormattingFunKt.getNORMAL_INDENT();

    @Override
    protected void adjustNestedNodes() {
        super.adjustNestedNodes();
        if (this.getNestedNodes().size() == 1 && this.getNestedNodes().get(0).getElementType() == SqlCompositeElementTypes.SQL_PARENTHESIZED_QUERY_EXPRESSION) {
            this.flattenNestedNodes((Function1<? super ASTNode, Boolean>)((Function1)adjustNestedNodes.1.INSTANCE));
        }
    }

    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        SqlBlock b2 = super.makeBlock(node);
        if (SqlUtilFun.isSymbol(node, '(')) {
            if (this.openingBlock == null) {
                this.openingBlock = b2;
            }
        } else if (SqlUtilFun.isSymbol(node, ')')) {
            this.closingBlock = b2;
        } else if (b2 instanceof SqlQueryBlock) {
            this.queryBlock = (SqlQueryBlock)b2;
        }
        return b2;
    }

    @Override
    protected void tuneNestedNodesAfterAnalysis() {
        Object v0;
        block4: {
            super.tuneNestedNodesAfterAnalysis();
            if (this.getShape() == BlockShape.DECIDED_TO_ONE_ROW) {
                return;
            }
            Iterable $this$firstOrNull$iv = this.getNestedBlocks();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBlock it2 = (SqlBlock)element$iv;
                boolean bl = false;
                if (!(it2 instanceof SqlQueryBlock)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        SqlBlock sqlBlock = v0;
        if (sqlBlock == null) {
            return;
        }
        SqlBlock q = sqlBlock;
        if (q.getShape() == BlockShape.DECIDED_TO_ONE_ROW) {
            q.setShape(this.getShape());
        }
    }

    @Override
    protected void configureFormattingAttributes() {
        block16: {
            Alignment alignment;
            Indent indent;
            boolean bl;
            Indent indent2;
            SqlCodeStyleSettings s = this.getContext().getSql();
            Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default((SqlFlowBlock)this, this.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? WrapType.ALWAYS : WrapType.CHOP_DOWN_IF_LONG, false, 2, null);
            switch (s.SUBQUERY_CONTENT) {
                case 3: {
                    Indent indent3 = Indent.getSpaceIndent((int)0, (boolean)true);
                    indent2 = indent3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)indent3, (String)"Indent.getSpaceIndent(0, true)");
                    break;
                }
                case 4: {
                    Indent indent4 = Indent.getNormalIndent((boolean)true);
                    indent2 = indent4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)indent4, (String)"Indent.getNormalIndent(true)");
                    break;
                }
                default: {
                    indent2 = SqlFormattingFunKt.getNORMAL_INDENT();
                }
            }
            this.defaultIndent = indent2;
            Alignment a1 = null;
            SqlBlock sqlBlock = this.openingBlock;
            if (sqlBlock != null) {
                Alignment parentAlignment;
                SqlBlock sqlBlock2 = sqlBlock;
                boolean bl2 = false;
                bl = false;
                SqlBlock it2 = sqlBlock2;
                boolean bl3 = false;
                it2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                Alignment alignment2 = parentAlignment = SqlFormattingModelFunKt.isAlways(this.getParent().getMyWrap()) ? this.getParent().getMyAlign() : null;
                if (parentAlignment == null) {
                    a1 = SqlFormattingModelFunKt.makeLeftAlignment();
                    it2.setMyAlign(a1);
                } else {
                    a1 = parentAlignment;
                    it2.setMyAlign(null);
                }
            }
            Alignment a2 = null;
            SqlQueryBlock sqlQueryBlock = this.queryBlock;
            if (sqlQueryBlock != null) {
                SqlQueryBlock sqlQueryBlock2 = sqlQueryBlock;
                bl = false;
                boolean bl4 = false;
                SqlQueryBlock it3 = sqlQueryBlock2;
                boolean bl5 = false;
                it3.setMyWrap((Wrap)(s.SUBQUERY_CONTENT >= 2 ? w : null));
                a2 = s.SUBQUERY_CONTENT == 3 ? a1 : (s.SUBQUERY_CLOSING == 6 ? SqlFormattingModelFunKt.makeLeftAlignment() : null);
                it3.setMyIndent(this.defaultIndent);
                it3.setMyAlign(a2);
            }
            SqlBlock sqlBlock3 = this.closingBlock;
            if (sqlBlock3 == null) break block16;
            SqlBlock sqlBlock4 = sqlBlock3;
            bl = false;
            boolean bl6 = false;
            SqlBlock it4 = sqlBlock4;
            boolean bl7 = false;
            it4.setMyWrap((Wrap)(s.SUBQUERY_CLOSING >= 2 ? w : null));
            switch (s.SUBQUERY_CLOSING) {
                case 3: 
                case 4: {
                    indent = Indent.getSpaceIndent((int)0, (boolean)true);
                    break;
                }
                case 6: {
                    indent = this.defaultIndent;
                    break;
                }
                default: {
                    indent = SqlFormattingFunKt.getNONE_INDENT();
                }
            }
            it4.setMyIndent(indent);
            switch (s.SUBQUERY_CLOSING) {
                case 4: {
                    alignment = a1;
                    break;
                }
                case 6: {
                    alignment = a2;
                    break;
                }
                default: {
                    alignment = null;
                }
            }
            it4.setMyAlign(alignment);
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return this.defaultIndent;
    }

    @Override
    public boolean userRequiresExpand() {
        return this.getContext().getSql().QUERY_IN_ONE_STRING == 1 || this.getContext().getSql().SUBQUERY_CONTENT >= 2;
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        return r1 == BlockRole.PREFIX || r2 == BlockRole.SUFFIX ? this.getContext().makeSpace(this.getContext().getSql().SUBQUERY_PAR_SPACE_INSIDE) : super.decideSpacing$intellij_database_sql_impl(block1, block2);
    }
}

