/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlAlterTableBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlColumnBlock;
import com.intellij.sql.formatter.model.SqlColumnDefaultBlock;
import com.intellij.sql.formatter.model.SqlColumnNullabilityBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nJ\u001f\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterTableBlock;", "Lcom/intellij/sql/formatter/model/SqlDdlStatementBlock;", "()V", "countOfElements", "", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "userRequiresExpand", "", "intellij.database.sql.impl"})
public final class SqlAlterTableBlock
extends SqlDdlStatementBlock {
    private int countOfElements;

    @Override
    @NotNull
    public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION)) ? BlockRole.ELEMENT : super.determineRole$intellij_database_sql_impl(node);
    }

    @Override
    public void countRole$intellij_database_sql_impl(@NotNull BlockRole role) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        super.countRole$intellij_database_sql_impl(role);
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        boolean toAlignDefaults;
        SqlCodeStyleSettings s = this.getContext().getSql();
        boolean toWrap = s.TABLE_ALTER_INSTRUCTION_WRAP == 1;
        boolean toAlign = s.TABLE_ALTER_INSTRUCTION_ALIGN && this.countOfElements >= 2;
        boolean toAlignTypes = s.TABLE_TYPES_ALIGN && this.countOfElements >= 2;
        boolean toAlignNullabilities = s.TABLE_NULLABILITIES_ALIGN && this.countOfElements >= 2;
        boolean bl = toAlignDefaults = s.TABLE_DEFAULTS_ALIGN && this.countOfElements >= 2;
        if (toWrap || toAlign || toAlignTypes || toAlignNullabilities || toAlignDefaults) {
            Wrap w = toWrap ? SqlFlowBlock.makeWrap$intellij_database_sql_impl$default((SqlFlowBlock)this, WrapType.ALWAYS, false, 2, null) : null;
            Alignment a = toAlign ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
            Alignment aT = toAlignTypes ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
            Alignment aN = toAlignNullabilities ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
            Alignment aD1 = toAlignDefaults ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
            Alignment aD2 = toAlignDefaults ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
            Iterable $this$filter$iv = this.getNestedBlocks();
            boolean $i$f$filter = false;
            Iterable $this$jbi$iv$iv = $this$filter$iv;
            boolean $i$f$getJbi = false;
            JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
            JBIterable jBIterable2 = jBIterable.filter(SqlAlterInstructionBlock.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
            Iterable $this$forEach$iv = (Iterable)jBIterable2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object v4;
                Object v3;
                SqlFlowBlock sqlFlowBlock;
                block9: {
                    void wrap$iv;
                    void this_$iv;
                    SqlAlterInstructionBlock alterInstructionBlock = (SqlAlterInstructionBlock)element$iv;
                    boolean bl2 = false;
                    sqlFlowBlock = alterInstructionBlock;
                    Wrap wrap = w;
                    Alignment align$iv22 = a;
                    Indent indent$iv = this_$iv.getMyIndent();
                    boolean $i$f$setAttributes22 = false;
                    this_$iv.setMyWrap((Wrap)wrap$iv);
                    this_$iv.setMyIndent(indent$iv);
                    this_$iv.setMyAlign(align$iv22);
                    if (!toAlignTypes && !toAlignNullabilities && !toAlignDefaults) continue;
                    Iterable $this$find$iv = alterInstructionBlock.getNestedBlocks();
                    boolean $i$f$find = false;
                    Iterable iterable = $this$find$iv;
                    boolean align$iv22 = false;
                    Iterable $i$f$setAttributes22 = iterable;
                    boolean bl3 = false;
                    for (Object t : $i$f$setAttributes22) {
                        Block it$iv = (Block)t;
                        boolean bl4 = false;
                        if (!(it$iv instanceof SqlColumnBlock)) continue;
                        v3 = t;
                        break block9;
                    }
                    v3 = v4 = null;
                }
                if (!(v3 instanceof SqlColumnBlock)) {
                    v4 = null;
                }
                SqlColumnBlock sqlColumnBlock = v4;
                if (sqlColumnBlock == null) continue;
                sqlFlowBlock = sqlColumnBlock;
                boolean bl5 = false;
                boolean bl6 = false;
                SqlFlowBlock columnBlock = sqlFlowBlock;
                boolean bl7 = false;
                boolean nullabilityWas = false;
                Iterable $this$forEach$iv2 = columnBlock.getNestedBlocks();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SqlBlock it2 = (SqlBlock)element$iv2;
                    boolean bl8 = false;
                    if (it2.getRole() == BlockRole.TYPE) {
                        it2.setMyAlign(aT);
                        continue;
                    }
                    if (it2 instanceof SqlColumnNullabilityBlock) {
                        nullabilityWas = true;
                        it2.setMyAlign(aN);
                        continue;
                    }
                    if (!(it2 instanceof SqlColumnDefaultBlock)) continue;
                    it2.setMyAlign(nullabilityWas ? aD2 : aD1);
                }
            }
        }
        if (s.TABLE_TYPES_ALIGN) {
            Alignment columnTypeAlignment = SqlFormattingModelFunKt.makeLeftAlignmentBS();
            Iterable $this$filter$iv = this.getNestedBlocks();
            boolean $i$f$filter = false;
            Iterable $this$jbi$iv$iv = $this$filter$iv;
            boolean $i$f$getJbi = false;
            JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
            JBIterable jBIterable3 = jBIterable.filter(SqlAlterInstructionBlock.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"this.jbi.filter(B::class.java)");
            JBIterable jBIterable4 = jBIterable3.flatten((Function)configureFormattingAttributes.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"nestedBlocks\n        .fi\u2026atten { it.nestedBlocks }");
            $this$filter$iv = (Iterable)jBIterable4;
            $i$f$filter = false;
            $this$jbi$iv$iv = $this$filter$iv;
            $i$f$getJbi = false;
            JBIterable jBIterable5 = JBIterable.from((Iterable)$this$jbi$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable5, (String)"JBIterable.from(this)");
            JBIterable jBIterable6 = jBIterable5.filter(SqlColumnBlock.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable6, (String)"this.jbi.filter(B::class.java)");
            JBIterable jBIterable7 = jBIterable6.flatten((Function)configureFormattingAttributes.3.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable7, (String)"nestedBlocks\n        .fi\u2026atten { it.nestedBlocks }");
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable7), BlockRole.BODY);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it3 = (SqlBlock)element$iv;
                boolean bl9 = false;
                it3.setMyAlign(columnTypeAlignment);
            }
        }
    }

    @Override
    public boolean userRequiresExpand() {
        return this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 1 || this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0;
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        return block2 instanceof SqlComma ? this.getContext().makeNoSpace(false) : (block2 instanceof SqlAlterInstructionBlock && this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0 ? this.getContext().makeAutoSpacing(true) : super.decideSpacing$intellij_database_sql_impl(block1, block2));
    }
}

